/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision.fixes;

import lombok.Generated;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="glass_pane$|iron_bars$", usesParams=true, passDefaultBoxes=true)
public class GlassPaneAndIronBarsCollision
extends BlockCollision {
    private int facing;

    public GlassPaneAndIronBarsCollision(BlockState state, BoundingBox[] defaultBoxes) {
        super(defaultBoxes);
        if (state.getValue(Properties.NORTH).booleanValue() && state.getValue(Properties.EAST).booleanValue()) {
            this.facing = 5;
        } else if (state.getValue(Properties.EAST).booleanValue() && state.getValue(Properties.SOUTH).booleanValue()) {
            this.facing = 6;
        } else if (state.getValue(Properties.SOUTH).booleanValue() && state.getValue(Properties.WEST).booleanValue()) {
            this.facing = 7;
        } else if (state.getValue(Properties.WEST).booleanValue() && state.getValue(Properties.NORTH).booleanValue()) {
            this.facing = 8;
        } else if (state.getValue(Properties.NORTH).booleanValue()) {
            this.facing = 1;
        } else if (state.getValue(Properties.EAST).booleanValue()) {
            this.facing = 2;
        } else if (state.getValue(Properties.SOUTH).booleanValue()) {
            this.facing = 3;
        } else if (state.getValue(Properties.WEST).booleanValue()) {
            this.facing = 4;
        }
    }

    @Override
    protected void correctPosition(GeyserSession session, int x, int y, int z, BoundingBox blockCollision, BoundingBox playerCollision, double ulpX, double ulpZ) {
        if (this.facing == 2 || this.facing == 6 || this.facing == 5) {
            blockCollision.pushOutOfBoundingBox(playerCollision, Direction.WEST, 0.0625 + ulpX);
        }
        if (this.facing == 1 || this.facing == 5 || this.facing == 8) {
            blockCollision.pushOutOfBoundingBox(playerCollision, Direction.SOUTH, 0.0625 + ulpZ);
        }
        if (this.facing == 3 || this.facing == 6 || this.facing == 7) {
            blockCollision.pushOutOfBoundingBox(playerCollision, Direction.NORTH, 0.0625 + ulpZ);
        }
        if (this.facing == 4 || this.facing == 7 || this.facing == 8) {
            blockCollision.pushOutOfBoundingBox(playerCollision, Direction.EAST, 0.0625 + ulpX);
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlassPaneAndIronBarsCollision)) {
            return false;
        }
        GlassPaneAndIronBarsCollision other = (GlassPaneAndIronBarsCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.facing == other.facing;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GlassPaneAndIronBarsCollision;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.facing;
        return result;
    }
}

