/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Color;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.skin.ImageData;
import org.cloudburstmc.protocol.bedrock.data.skin.SerializedSkin;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerListPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerSkinPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.skin.Cape;
import org.geysermc.geyser.api.skin.Skin;
import org.geysermc.geyser.api.skin.SkinData;
import org.geysermc.geyser.api.skin.SkinGeometry;
import org.geysermc.geyser.entity.type.player.AvatarEntity;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.auth.BedrockClientData;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.geyser.util.PlayerListUtils;
import org.geysermc.geyser.util.WebUtils;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.ResolvableProfile;

public class SkinManager {
    private static final Map<ResolvableProfile, CompletableFuture<GameProfile>> requestedProfiles = new ConcurrentHashMap<ResolvableProfile, CompletableFuture<GameProfile>>();
    private static final Cache<ResolvableProfile, GameProfile> RESOLVED_PROFILES_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private static final UUID EMPTY_UUID = new UUID(0L, 0L);
    static final String GEOMETRY = new String(FileUtils.readAllBytes("bedrock/geometries/geo.json"), StandardCharsets.UTF_8);

    public static PlayerListPacket.Entry buildEntryFromCachedSkin(GeyserSession session, AvatarEntity playerEntity) {
        GameProfileData data = GameProfileData.from(playerEntity);
        Skin skin = null;
        Cape cape = null;
        SkinGeometry geometry = SkinGeometry.WIDE;
        if (data != null) {
            skin = SkinProvider.getCachedSkin(data.skinUrl());
            cape = SkinProvider.getCachedCape(data.capeUrl());
            SkinGeometry skinGeometry = geometry = data.isSlim() ? SkinGeometry.SLIM : SkinGeometry.WIDE;
        }
        if (skin == null || cape == null) {
            SkinData fallbackSkinData = SkinProvider.determineFallbackSkinData(playerEntity.uuid());
            if (skin == null) {
                skin = fallbackSkinData.skin();
                geometry = fallbackSkinData.geometry();
            }
            if (cape == null) {
                cape = fallbackSkinData.cape();
            }
        }
        return PlayerListUtils.buildEntryManually(session, playerEntity.uuid(), playerEntity.getUsername(), playerEntity.geyserId(), SkinManager.getSkin(session, skin.textureUrl(), skin, cape, geometry), session.getWaypointCache().getWaypointColor(playerEntity.uuid()).orElse(Color.WHITE));
    }

    public static void sendSkinPacket(GeyserSession session, AvatarEntity entity, SkinData skinData) {
        Skin skin = skinData.skin();
        Cape cape = skinData.cape();
        SkinGeometry geometry = skinData.geometry();
        if (entity.uuid().equals(session.getPlayerEntity().uuid()) || GameProtocol.is1_21_130orHigher(session.protocolVersion()) && !entity.isListed()) {
            PlayerListPacket.Entry entry = PlayerListUtils.buildEntryManually(session, entity.uuid(), entity.getUsername(), entity.geyserId(), SkinManager.getSkin(session, skin.textureUrl(), skin, cape, geometry), session.getWaypointCache().getWaypointColor(entity.uuid()).orElse(Color.WHITE));
            session.scheduleInEventLoop(() -> PlayerListUtils.sendSkinUsingPlayerList(session, entry, entity, entity.isListed()), 100L, TimeUnit.MILLISECONDS);
        } else {
            PlayerSkinPacket packet = new PlayerSkinPacket();
            packet.setUuid(entity.uuid());
            packet.setOldSkinName("");
            packet.setNewSkinName(skin.textureUrl());
            packet.setSkin(SkinManager.getSkin(session, skin.textureUrl(), skin, cape, geometry));
            packet.setTrustedSkin(true);
            session.sendUpstreamPacket((BedrockPacket)packet);
        }
    }

    private static SerializedSkin getSkin(GeyserSession session, String skinId, Skin skin, Cape cape, SkinGeometry geometry) {
        return SerializedSkin.builder().skinId(skinId).skinResourcePatch(geometry.geometryName()).skinData(ImageData.of((byte[])skin.skinData())).capeData(ImageData.of((byte[])cape.capeData())).geometryData(geometry.geometryData().isBlank() ? GEOMETRY : geometry.geometryData()).premium(true).capeId(cape.capeId()).fullSkinId(skinId).geometryDataEngineVersion(session.getClientData().getGameVersion()).overridingPlayerAppearance(true).build();
    }

    public static CompletableFuture<GameProfile> resolveProfile(ResolvableProfile profile) {
        GameProfile partial = profile.getProfile();
        if (!profile.isDynamic()) {
            return CompletableFuture.completedFuture(partial);
        }
        if (!partial.getProperties().isEmpty() || partial.getId() == null && partial.getName() == null) {
            String name = partial.getName() == null ? "" : partial.getName();
            UUID uuid = partial.getName() == null ? EMPTY_UUID : SkinManager.createOfflinePlayerUUID(partial.getName());
            GameProfile completed = new GameProfile(uuid, name);
            completed.setProperties(partial.getProperties());
            return CompletableFuture.completedFuture(completed);
        }
        GameProfile cached = (GameProfile)RESOLVED_PROFILES_CACHE.getIfPresent((Object)profile);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached);
        }
        return requestedProfiles.computeIfAbsent(profile, resolvableProfile -> {
            CompletionStage future = ((CompletableFuture)((CompletableFuture)(partial.getName() != null ? SkinProvider.requestUUIDFromUsername(partial.getName()).thenApply(uuid -> new GameProfile(uuid, partial.getName())) : SkinProvider.requestUsernameFromUUID(partial.getId()).thenApply(name -> new GameProfile(partial.getId(), name)))).thenCompose(nameAndUUID -> {
                if (nameAndUUID.getId() == null || nameAndUUID.getName() == null) {
                    return CompletableFuture.completedFuture(partial);
                }
                return SkinProvider.requestTexturesFromUUID(nameAndUUID.getId()).thenApply(encoded -> {
                    if (encoded == null) {
                        return partial;
                    }
                    nameAndUUID.setProperties(List.of(new GameProfile.Property("textures", encoded)));
                    return nameAndUUID;
                });
            })).thenApply(resolved -> {
                RESOLVED_PROFILES_CACHE.put(resolvableProfile, resolved);
                return resolved;
            });
            return ((CompletableFuture)future).whenComplete((r, t) -> requestedProfiles.remove(resolvableProfile));
        });
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable GameProfile.Texture getTextureDataFromProfile(GameProfile profile, GameProfile.TextureType type) {
        Map textures;
        try {
            textures = profile.getTextures(false);
        }
        catch (IllegalStateException e) {
            GeyserImpl.getInstance().getLogger().debug("Could not decode textures from game profile (%s)! Got: %s", profile, e);
            return null;
        }
        if (textures == null) {
            return null;
        }
        return (GameProfile.Texture)textures.get(type);
    }

    public static void requestAndHandleSkinAndCape(AvatarEntity entity, GeyserSession session, Consumer<SkinProvider.SkinAndCape> skinAndCapeConsumer) {
        SkinProvider.requestSkinData(entity, session).whenCompleteAsync((skinData, throwable) -> {
            if (skinData != null && skinData.geometry() != null) {
                SkinManager.sendSkinPacket(session, entity, skinData);
            }
            if (skinAndCapeConsumer != null) {
                skinAndCapeConsumer.accept(skinData == null ? null : new SkinProvider.SkinAndCape(skinData.skin(), skinData.cape()));
            }
        });
    }

    public static void handleBedrockSkin(AvatarEntity playerEntity, BedrockClientData clientData) {
        GeyserImpl geyser = GeyserImpl.getInstance();
        if (geyser.config().debugMode()) {
            geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.skin.bedrock.register", playerEntity.getUsername(), playerEntity.uuid()));
        }
        try {
            byte[] skinBytes = clientData.getSkinData();
            byte[] capeBytes = clientData.getCapeData();
            byte[] geometryNameBytes = clientData.getGeometryName();
            byte[] geometryBytes = clientData.getGeometryData();
            if (skinBytes.length <= 65536 && !clientData.isPersonaSkin()) {
                SkinProvider.storeBedrockSkin(playerEntity.uuid(), clientData.getSkinId(), skinBytes);
                SkinProvider.storeBedrockGeometry(playerEntity.uuid(), geometryNameBytes, geometryBytes);
            } else if (geyser.config().debugMode()) {
                geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.skin.bedrock.fail", playerEntity.getUsername()));
                geyser.getLogger().debug("The size of '" + playerEntity.getUsername() + "' skin is: " + clientData.getSkinImageWidth() + "x" + clientData.getSkinImageHeight());
            }
            if (!clientData.getCapeId().equals("")) {
                SkinProvider.storeBedrockCape(clientData.getCapeId(), capeBytes);
            }
        }
        catch (Exception e) {
            throw new AssertionError("Failed to cache skin for bedrock user (" + playerEntity.getUsername() + "): ", e);
        }
    }

    public static UUID createOfflinePlayerUUID(String username) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
    }

    public record GameProfileData(String skinUrl, String capeUrl, boolean isSlim) {
        private static final String DEFAULT_FLOODGATE_STEVE = "https://textures.minecraft.net/texture/31f477eb1a7beee631c2ca64d06f8f68fa93a3386d04452ab27f43acdf1b60cb";

        public static @Nullable GameProfileData from(AvatarEntity entity) {
            Map<GameProfile.TextureType, GameProfile.Texture> textures = entity.getTextures();
            if (textures == null) {
                return null;
            }
            GameProfile.Texture skin = textures.get(GameProfile.TextureType.SKIN);
            if (skin == null) {
                return null;
            }
            String skinUrl = WebUtils.toHttps(skin.getURL());
            if (Objects.equals(DEFAULT_FLOODGATE_STEVE, skinUrl)) {
                return null;
            }
            GameProfile.Texture cape = textures.get(GameProfile.TextureType.CAPE);
            String capeUrl = cape == null ? null : WebUtils.toHttps(cape.getURL());
            return new GameProfileData(skinUrl, capeUrl, skin.getModel() == GameProfile.TextureModel.SLIM);
        }
    }
}

