/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3f;

public class TeleportCache {
    private static final float ERROR_X_AND_Z = 0.1f;
    private static final float ERROR_Y = 0.1f;
    private static final int RESEND_THRESHOLD = 20;
    private final Vector3f position;
    private final Vector3f velocity;
    private final float pitch;
    private final float yaw;
    private final int teleportConfirmId;
    private final TeleportType teleportType;
    private int unconfirmedFor = 0;

    public TeleportCache(Vector3f position, float pitch, float yaw, int teleportConfirmId) {
        this.position = position;
        this.velocity = Vector3f.ZERO;
        this.pitch = pitch;
        this.yaw = yaw;
        this.teleportConfirmId = teleportConfirmId;
        this.teleportType = TeleportType.NORMAL;
    }

    public boolean canConfirm(Vector3f position) {
        float distanceX = Math.abs(this.position.getX() - position.getX());
        float distanceY = Math.abs(this.position.getY() - position.getY());
        float distanceZ = Math.abs(this.position.getZ() - position.getZ());
        return distanceX < 0.1f && distanceY < 0.1f && distanceZ < 0.1f;
    }

    public void incrementUnconfirmedFor() {
        ++this.unconfirmedFor;
    }

    public void resetUnconfirmedFor() {
        this.unconfirmedFor = 0;
    }

    public boolean shouldResend() {
        return this.unconfirmedFor >= 20;
    }

    @Generated
    public TeleportCache(Vector3f position, Vector3f velocity, float pitch, float yaw, int teleportConfirmId, TeleportType teleportType) {
        this.position = position;
        this.velocity = velocity;
        this.pitch = pitch;
        this.yaw = yaw;
        this.teleportConfirmId = teleportConfirmId;
        this.teleportType = teleportType;
    }

    @Generated
    public Vector3f getPosition() {
        return this.position;
    }

    @Generated
    public Vector3f getVelocity() {
        return this.velocity;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public int getTeleportConfirmId() {
        return this.teleportConfirmId;
    }

    @Generated
    public TeleportType getTeleportType() {
        return this.teleportType;
    }

    @Generated
    public int getUnconfirmedFor() {
        return this.unconfirmedFor;
    }

    @Generated
    public void setUnconfirmedFor(int unconfirmedFor) {
        this.unconfirmedFor = unconfirmedFor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TeleportCache)) {
            return false;
        }
        TeleportCache other = (TeleportCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (this.getTeleportConfirmId() != other.getTeleportConfirmId()) {
            return false;
        }
        if (this.getUnconfirmedFor() != other.getUnconfirmedFor()) {
            return false;
        }
        Vector3f this$position = this.getPosition();
        Vector3f other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        Vector3f this$velocity = this.getVelocity();
        Vector3f other$velocity = other.getVelocity();
        if (this$velocity == null ? other$velocity != null : !this$velocity.equals(other$velocity)) {
            return false;
        }
        TeleportType this$teleportType = this.getTeleportType();
        TeleportType other$teleportType = other.getTeleportType();
        return !(this$teleportType == null ? other$teleportType != null : !((Object)((Object)this$teleportType)).equals((Object)other$teleportType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TeleportCache;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + this.getTeleportConfirmId();
        result = result * 59 + this.getUnconfirmedFor();
        Vector3f $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        Vector3f $velocity = this.getVelocity();
        result = result * 59 + ($velocity == null ? 43 : $velocity.hashCode());
        TeleportType $teleportType = this.getTeleportType();
        result = result * 59 + ($teleportType == null ? 43 : ((Object)((Object)$teleportType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TeleportCache(position=" + String.valueOf(this.getPosition()) + ", velocity=" + String.valueOf(this.getVelocity()) + ", pitch=" + this.getPitch() + ", yaw=" + this.getYaw() + ", teleportConfirmId=" + this.getTeleportConfirmId() + ", teleportType=" + String.valueOf((Object)this.getTeleportType()) + ", unconfirmedFor=" + this.getUnconfirmedFor() + ")";
    }

    public static enum TeleportType {
        NORMAL,
        KEEP_VELOCITY;

    }
}

