/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.player.SkullPlayerEntity;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.WallSkullBlock;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.CustomSkull;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.auth.GameProfile;

public class SkullCache {
    private final int maxVisibleSkulls;
    private final boolean cullingEnabled;
    private final int skullRenderDistanceSquared;
    private final Map<Vector3i, Skull> skulls = new Object2ObjectOpenHashMap();
    private final List<Skull> inRangeSkulls = new ArrayList<Skull>();
    private int totalSkullEntities = 0;
    private final GeyserSession session;
    private Vector3f lastPlayerPosition;

    public SkullCache(GeyserSession session) {
        this.session = session;
        this.maxVisibleSkulls = session.getGeyser().config().gameplay().maxVisibleCustomSkulls();
        this.cullingEnabled = this.maxVisibleSkulls != -1;
        int distance = Math.min(session.getGeyser().config().gameplay().customSkullRenderDistance(), 64);
        this.skullRenderDistanceSquared = distance * distance;
    }

    public @Nullable Skull putSkull(Vector3i position, GameProfile resolved, BlockState blockState) {
        GameProfile.Texture texture;
        try {
            texture = resolved.getTexture(GameProfile.TextureType.SKIN, false);
        }
        catch (IllegalStateException e) {
            this.session.getGeyser().getLogger().debug("Player skull with invalid skin found at " + String.valueOf(position) + " with texture payload " + String.valueOf(resolved.getProperty("textures")));
            return null;
        }
        if (texture != null) {
            return this.putSkull(position, resolved.getId(), texture.getURL(), texture.getHash(), blockState);
        }
        return null;
    }

    public Skull putSkull(Vector3i position, UUID uuid, String skinUrl, String skinHash, BlockState blockState) {
        Skull skull = this.skulls.computeIfAbsent(position, Skull::new);
        skull.uuid = uuid;
        skull.skinUrl = skinUrl;
        skull.skinHash = skinHash;
        skull.blockState = blockState;
        skull.blockDefinition = this.translateCustomSkull(skull.skinHash, blockState);
        if (skull.blockDefinition != null) {
            this.reassignSkullEntity(skull);
            return skull;
        }
        if (skull.entity != null) {
            skull.entity.updateSkull(skull);
        } else {
            if (!this.cullingEnabled) {
                this.assignSkullEntity(skull);
                return skull;
            }
            if (this.lastPlayerPosition == null) {
                return skull;
            }
            skull.distanceSquared = position.distanceSquared((double)this.lastPlayerPosition.getX(), (double)this.lastPlayerPosition.getY(), (double)this.lastPlayerPosition.getZ());
            if (skull.distanceSquared < this.skullRenderDistanceSquared) {
                int i = Collections.binarySearch(this.inRangeSkulls, skull, Comparator.comparingInt(Skull::getDistanceSquared));
                if (i < 0) {
                    i = -i - 1;
                }
                this.inRangeSkulls.add(i, skull);
                if (i < this.maxVisibleSkulls) {
                    if (this.inRangeSkulls.size() > this.maxVisibleSkulls) {
                        this.freeSkullEntity(this.inRangeSkulls.get(this.maxVisibleSkulls));
                    }
                    this.assignSkullEntity(skull);
                }
            }
        }
        return skull;
    }

    public void removeSkull(Vector3i position) {
        Skull skull = this.skulls.remove(position);
        if (skull != null) {
            this.reassignSkullEntity(skull);
        }
    }

    public Skull updateSkull(Vector3i position, BlockState blockState) {
        Skull skull = this.skulls.get(position);
        if (skull != null) {
            this.putSkull(position, skull.uuid, skull.skinUrl, skull.skinHash, blockState);
        }
        return skull;
    }

    public void updateVisibleSkulls() {
        if (this.cullingEnabled) {
            if (this.lastPlayerPosition != null && this.session.getPlayerEntity().getPosition().distanceSquared(this.lastPlayerPosition) < 4.0f) {
                return;
            }
            this.lastPlayerPosition = this.session.getPlayerEntity().getPosition();
            this.inRangeSkulls.clear();
            for (Skull skull : this.skulls.values()) {
                if (skull.blockDefinition != null) continue;
                skull.distanceSquared = skull.position.distanceSquared((double)this.lastPlayerPosition.getX(), (double)this.lastPlayerPosition.getY(), (double)this.lastPlayerPosition.getZ());
                if (skull.distanceSquared > this.skullRenderDistanceSquared) {
                    this.freeSkullEntity(skull);
                    continue;
                }
                this.inRangeSkulls.add(skull);
            }
            this.inRangeSkulls.sort(Comparator.comparingInt(Skull::getDistanceSquared));
            for (int i = this.inRangeSkulls.size() - 1; i >= 0; --i) {
                if (i < this.maxVisibleSkulls) {
                    this.assignSkullEntity(this.inRangeSkulls.get(i));
                    continue;
                }
                this.freeSkullEntity(this.inRangeSkulls.get(i));
            }
        }
    }

    private void assignSkullEntity(Skull skull) {
        if (skull.entity != null) {
            return;
        }
        if (!this.cullingEnabled || this.totalSkullEntities < this.maxVisibleSkulls) {
            skull.entity = new SkullPlayerEntity((EntitySpawnContext)EntitySpawnContext.DUMMY_CONTEXT.apply((Object)this.session, (Object)UUID.randomUUID(), EntityDefinitions.PLAYER));
            skull.entity.spawnEntity();
            skull.entity.updateSkull(skull);
            ++this.totalSkullEntities;
        }
    }

    private void freeSkullEntity(Skull skull) {
        if (skull.entity != null) {
            skull.entity.despawnEntity();
            --this.totalSkullEntities;
            skull.entity = null;
        }
    }

    private void reassignSkullEntity(Skull skull) {
        boolean hadEntity = skull.entity != null;
        this.freeSkullEntity(skull);
        if (this.cullingEnabled) {
            this.inRangeSkulls.remove(skull);
            if (hadEntity && this.inRangeSkulls.size() >= this.maxVisibleSkulls) {
                this.assignSkullEntity(this.inRangeSkulls.get(this.maxVisibleSkulls - 1));
            }
        }
    }

    public void clear() {
        for (Skull skull : this.skulls.values()) {
            if (skull.entity == null) continue;
            skull.entity.despawnEntity();
        }
        this.skulls.clear();
        this.inRangeSkulls.clear();
        this.totalSkullEntities = 0;
        this.lastPlayerPosition = null;
    }

    private @Nullable BlockDefinition translateCustomSkull(@Nullable String skinHash, BlockState blockState) {
        if (skinHash == null) {
            return null;
        }
        CustomSkull customSkull = (CustomSkull)BlockRegistries.CUSTOM_SKULLS.get(skinHash);
        if (customSkull != null) {
            CustomBlockState customBlockState = blockState.block() instanceof WallSkullBlock ? customSkull.getWallBlockState(WallSkullBlock.getDegrees(blockState)) : customSkull.getFloorBlockState(blockState.getValue(Properties.ROTATION_16));
            return (BlockDefinition)this.session.getBlockMappings().getCustomBlockStateDefinitions().get((Object)customBlockState);
        }
        return null;
    }

    @Generated
    public Map<Vector3i, Skull> getSkulls() {
        return this.skulls;
    }

    public static class Skull {
        private UUID uuid;
        private String skinHash;
        private String skinUrl;
        private BlockState blockState;
        private BlockDefinition blockDefinition;
        private SkullPlayerEntity entity;
        private final Vector3i position;
        private int distanceSquared;

        @Generated
        public Skull(Vector3i position) {
            this.position = position;
        }

        @Generated
        public UUID getUuid() {
            return this.uuid;
        }

        @Generated
        public String getSkinHash() {
            return this.skinHash;
        }

        @Generated
        public String getSkinUrl() {
            return this.skinUrl;
        }

        @Generated
        public BlockState getBlockState() {
            return this.blockState;
        }

        @Generated
        public BlockDefinition getBlockDefinition() {
            return this.blockDefinition;
        }

        @Generated
        public SkullPlayerEntity getEntity() {
            return this.entity;
        }

        @Generated
        public Vector3i getPosition() {
            return this.position;
        }

        @Generated
        public int getDistanceSquared() {
            return this.distanceSquared;
        }

        @Generated
        public void setUuid(UUID uuid) {
            this.uuid = uuid;
        }

        @Generated
        public void setSkinHash(String skinHash) {
            this.skinHash = skinHash;
        }

        @Generated
        public void setSkinUrl(String skinUrl) {
            this.skinUrl = skinUrl;
        }

        @Generated
        public void setBlockState(BlockState blockState) {
            this.blockState = blockState;
        }

        @Generated
        public void setBlockDefinition(BlockDefinition blockDefinition) {
            this.blockDefinition = blockDefinition;
        }

        @Generated
        public void setEntity(SkullPlayerEntity entity) {
            this.entity = entity;
        }

        @Generated
        public void setDistanceSquared(int distanceSquared) {
            this.distanceSquared = distanceSquared;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Skull)) {
                return false;
            }
            Skull other = (Skull)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDistanceSquared() != other.getDistanceSquared()) {
                return false;
            }
            UUID this$uuid = this.getUuid();
            UUID other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
                return false;
            }
            String this$skinHash = this.getSkinHash();
            String other$skinHash = other.getSkinHash();
            if (this$skinHash == null ? other$skinHash != null : !this$skinHash.equals(other$skinHash)) {
                return false;
            }
            String this$skinUrl = this.getSkinUrl();
            String other$skinUrl = other.getSkinUrl();
            if (this$skinUrl == null ? other$skinUrl != null : !this$skinUrl.equals(other$skinUrl)) {
                return false;
            }
            BlockState this$blockState = this.getBlockState();
            BlockState other$blockState = other.getBlockState();
            if (this$blockState == null ? other$blockState != null : !this$blockState.equals(other$blockState)) {
                return false;
            }
            BlockDefinition this$blockDefinition = this.getBlockDefinition();
            BlockDefinition other$blockDefinition = other.getBlockDefinition();
            if (this$blockDefinition == null ? other$blockDefinition != null : !this$blockDefinition.equals(other$blockDefinition)) {
                return false;
            }
            SkullPlayerEntity this$entity = this.getEntity();
            SkullPlayerEntity other$entity = other.getEntity();
            if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                return false;
            }
            Vector3i this$position = this.getPosition();
            Vector3i other$position = other.getPosition();
            return !(this$position == null ? other$position != null : !this$position.equals(other$position));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Skull;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDistanceSquared();
            UUID $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
            String $skinHash = this.getSkinHash();
            result = result * 59 + ($skinHash == null ? 43 : $skinHash.hashCode());
            String $skinUrl = this.getSkinUrl();
            result = result * 59 + ($skinUrl == null ? 43 : $skinUrl.hashCode());
            BlockState $blockState = this.getBlockState();
            result = result * 59 + ($blockState == null ? 43 : $blockState.hashCode());
            BlockDefinition $blockDefinition = this.getBlockDefinition();
            result = result * 59 + ($blockDefinition == null ? 43 : $blockDefinition.hashCode());
            SkullPlayerEntity $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            Vector3i $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : $position.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SkullCache.Skull(uuid=" + String.valueOf(this.getUuid()) + ", skinHash=" + this.getSkinHash() + ", skinUrl=" + this.getSkinUrl() + ", blockState=" + String.valueOf(this.getBlockState()) + ", blockDefinition=" + String.valueOf(this.getBlockDefinition()) + ", entity=" + String.valueOf(this.getEntity()) + ", position=" + String.valueOf(this.getPosition()) + ", distanceSquared=" + this.getDistanceSquared() + ")";
        }
    }
}

