/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.cloudburstmc.protocol.bedrock.data.AttributeData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ClientboundCloseFormPacket;
import org.cloudburstmc.protocol.bedrock.packet.ModalFormRequestPacket;
import org.cloudburstmc.protocol.bedrock.packet.ModalFormResponsePacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.impl.FormDefinitions;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.session.GeyserSession;

public class FormCache {
    private static final long MAGIC_FORM_IMAGE_HACK_TIMESTAMP = -1234567890L;
    private final FormDefinitions formDefinitions = FormDefinitions.instance();
    private final AtomicInteger formIdCounter = new AtomicInteger(0);
    private final Int2ObjectMap<Form> forms = new Int2ObjectOpenHashMap();
    private final GeyserSession session;

    public boolean hasFormOpen() {
        return !this.forms.isEmpty();
    }

    public int addForm(Form form) {
        int formId = this.formIdCounter.getAndIncrement();
        this.forms.put(formId, (Object)form);
        return formId;
    }

    public void showForm(Form form) {
        int formId = this.addForm(form);
        if (this.session.getUpstream().isInitialized()) {
            this.sendForm(formId, form);
        }
    }

    private void sendForm(int formId, Form form) {
        String jsonData = this.formDefinitions.codecFor(form).jsonData(form);
        ModalFormRequestPacket formRequestPacket = new ModalFormRequestPacket();
        formRequestPacket.setFormId(formId);
        formRequestPacket.setFormData(jsonData);
        this.session.sendUpstreamPacket((BedrockPacket)formRequestPacket);
        if (form instanceof SimpleForm) {
            this.session.scheduleInEventLoop(() -> this.session.sendNetworkLatencyStackPacket(-1234567890L, false, () -> this.session.scheduleInEventLoop(() -> {
                UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
                attributesPacket.setRuntimeEntityId(this.session.getPlayerEntity().geyserId());
                AttributeData attribute = this.session.getPlayerEntity().getAttributes().get((Object)GeyserAttributeType.EXPERIENCE_LEVEL);
                if (attribute != null) {
                    attributesPacket.setAttributes(Collections.singletonList(attribute));
                } else {
                    attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.EXPERIENCE_LEVEL.getAttribute(0.0f)));
                }
                this.session.sendUpstreamPacket((BedrockPacket)attributesPacket);
            }, 500L, TimeUnit.MILLISECONDS)), 500L, TimeUnit.MILLISECONDS);
        }
    }

    public void resendAllForms() {
        for (Int2ObjectMap.Entry entry : this.forms.int2ObjectEntrySet()) {
            this.sendForm(entry.getIntKey(), (Form)entry.getValue());
        }
    }

    public void handleResponse(ModalFormResponsePacket response) {
        Form form = (Form)this.forms.remove(response.getFormId());
        if (form == null) {
            return;
        }
        try {
            this.formDefinitions.definitionFor(form).handleFormResponse(form, response.getFormData());
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error("Error while processing form response!", e);
        }
    }

    public void closeForms() {
        if (!this.forms.isEmpty()) {
            Int2ObjectOpenHashMap copy = new Int2ObjectOpenHashMap(this.forms);
            this.forms.clear();
            this.session.sendUpstreamPacket((BedrockPacket)new ClientboundCloseFormPacket());
            for (Form form : copy.values()) {
                try {
                    this.formDefinitions.definitionFor(form).handleFormResponse(form, "");
                }
                catch (Exception e) {
                    GeyserImpl.getInstance().getLogger().error("Error while closing form!", e);
                }
            }
        }
    }

    @Generated
    public FormCache(GeyserSession session) {
        this.session = session;
    }
}

