/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.Pair;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.cloudburstmc.protocol.bedrock.data.PlayerActionType;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.data.PlayerBlockActionData;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.translator.item.CustomItemTranslator;
import org.geysermc.geyser.translator.protocol.bedrock.BedrockInventoryTransactionTranslator;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.BlockBreakStage;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.InteractAction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerAction;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.AdventureModePredicate;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ToolData;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundInteractPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerActionPacket;

public class BlockBreakHandler {
    protected final GeyserSession session;
    protected @Nullable Vector3i currentBlockPos = null;
    protected @Nullable BlockState currentBlockState = null;
    protected @Nullable Integer updatedServerBlockStateId;
    protected boolean serverSideBlockBreaking = false;
    protected float currentProgress = 0.0f;
    protected Direction currentBlockFace = null;
    protected GeyserItemStack currentItemStack = null;
    protected Vector3i lastMinedPosition = null;
    protected Set<Vector3i> restoredBlocks = new HashSet<Vector3i>(2);
    protected @Nullable Vector3i itemFramePos = null;
    private final Cache<Vector3i, Pair<Long, BlockBreakStage>> destructionStageCache = CacheBuilder.newBuilder().maximumSize(200L).expireAfterWrite(3L, TimeUnit.MINUTES).build();
    private final BlockPredicateCache blockPredicateCache = new BlockPredicateCache();

    public BlockBreakHandler(GeyserSession session) {
        this.session = session;
    }

    public void handlePlayerAuthInputPacket(PlayerAuthInputPacket packet) {
        if (packet.getInputData().contains(PlayerAuthInputData.PERFORM_BLOCK_ACTIONS)) {
            this.handleBlockBreakActions(packet);
            this.restoredBlocks.clear();
            this.itemFramePos = null;
        } else {
            this.tick(packet.getTick());
        }
    }

    protected void tick(long tick) {
        if (this.currentBlockFace != null && this.currentBlockPos != null && this.currentBlockState != null) {
            this.handleContinueDestroy(this.currentBlockPos, this.getCurrentBlockState(this.currentBlockPos), this.currentBlockFace, false, false, this.session.getClientTicks());
        }
    }

    protected void handleBlockBreakActions(PlayerAuthInputPacket packet) {
        block7: for (int i = 0; i < packet.getPlayerActions().size(); ++i) {
            PlayerBlockActionData actionData = (PlayerBlockActionData)packet.getPlayerActions().get(i);
            Vector3i position = actionData.getBlockPosition();
            switch (actionData.getAction()) {
                case DROP_ITEM: {
                    ServerboundPlayerActionPacket dropItemPacket = new ServerboundPlayerActionPacket(PlayerAction.DROP_ITEM, position, Direction.getUntrusted(actionData, PlayerBlockActionData::getFace).mcpl(), 0);
                    this.session.sendDownstreamGamePacket((Packet)dropItemPacket);
                    continue block7;
                }
                case START_BREAK: {
                    this.lastMinedPosition = null;
                    if (this.testForItemFrameEntity(position) || this.abortDueToBlockRestoring(position)) continue block7;
                    BlockState state = this.getCurrentBlockState(position);
                    if (!this.canBreak(position, state, actionData.getAction())) {
                        BlockUtils.sendBedrockStopBlockBreak(this.session, position.toFloat());
                        this.restoredBlocks.add(position);
                        continue block7;
                    }
                    this.handleStartBreak(position, state, Direction.getUntrusted(actionData, PlayerBlockActionData::getFace), packet.getTick());
                    continue block7;
                }
                case BLOCK_CONTINUE_DESTROY: {
                    PlayerBlockActionData nextAction;
                    if (this.testForItemFrameEntity(position) || this.testForLastBreakPosOrReset(position) || this.abortDueToBlockRestoring(position) || Objects.equals(this.currentBlockPos, position) && i < packet.getPlayerActions().size() - 1 && Objects.equals((nextAction = (PlayerBlockActionData)packet.getPlayerActions().get(i + 1)).getBlockPosition(), position)) continue block7;
                    BlockState state = this.getCurrentBlockState(position);
                    if (!this.canBreak(position, state, actionData.getAction())) {
                        BlockUtils.sendBedrockStopBlockBreak(this.session, position.toFloat());
                        this.restoredBlocks.add(position);
                        if (Objects.equals(this.currentBlockPos, position)) continue block7;
                        this.handleAbortBreaking(position);
                        continue block7;
                    }
                    this.handleContinueDestroy(position, state, Direction.getUntrusted(actionData, PlayerBlockActionData::getFace), false, true, packet.getTick());
                    continue block7;
                }
                case BLOCK_PREDICT_DESTROY: {
                    boolean valid;
                    if (this.testForItemFrameEntity(position)) continue block7;
                    if (Objects.equals(this.lastMinedPosition, position)) {
                        this.lastMinedPosition = null;
                        continue block7;
                    }
                    if (!this.restoredBlocks.isEmpty()) {
                        BlockUtils.restoreCorrectBlock(this.session, position, this.session.getPlayerInventory().getHeldItemSlot());
                        continue block7;
                    }
                    BlockState state = this.getCurrentBlockState(position);
                    boolean bl = valid = this.currentBlockPos != null && Objects.equals(position, this.currentBlockPos);
                    if (!this.canBreak(position, state, actionData.getAction()) || !valid) {
                        if (!valid) {
                            GeyserImpl.getInstance().getLogger().warning("Player %s tried to break block at %s (%s), without starting to destroy it!".formatted(this.session.bedrockUsername(), position, this.currentBlockPos));
                            this.handleAbortBreaking(this.currentBlockPos);
                        }
                        BlockUtils.stopBreakAndRestoreBlock(this.session, position, state);
                        this.restoredBlocks.add(position);
                        continue block7;
                    }
                    this.handlePredictDestroy(position, state, Direction.getUntrusted(actionData, PlayerBlockActionData::getFace), packet.getTick());
                    continue block7;
                }
                case ABORT_BREAK: {
                    if (this.testForItemFrameEntity(position)) continue block7;
                    this.handleAbortBreaking(position);
                    continue block7;
                }
                default: {
                    GeyserImpl.getInstance().getLogger().warning("Unknown block break action (%s) received! (origin: %s)!".formatted(actionData.getAction(), this.session.getDebugInfo()));
                    GeyserImpl.getInstance().getLogger().debug("Odd packet: " + String.valueOf(packet));
                    this.session.disconnect("Invalid block breaking action received!");
                }
            }
        }
    }

    protected void handleStartBreak(@NonNull Vector3i position, @NonNull BlockState state, Direction blockFace, long tick) {
        GeyserItemStack item = this.session.getPlayerInventory().getItemInHand();
        Vector3i fireBlockPos = BlockUtils.getBlockPosition(position, blockFace);
        Block possibleFireBlock = this.session.getGeyser().getWorldManager().blockAt(this.session, fireBlockPos).block();
        if (possibleFireBlock == Blocks.FIRE || possibleFireBlock == Blocks.SOUL_FIRE) {
            ServerboundPlayerActionPacket startBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.START_DIGGING, fireBlockPos, blockFace.mcpl(), this.session.getWorldCache().nextPredictionSequence());
            this.session.sendDownstreamGamePacket((Packet)startBreakingPacket);
        }
        float breakProgress = this.calculateBreakProgress(state, position, item);
        if (this.session.isInstabuild() || breakProgress >= 1.0f) {
            this.destroyBlock(state, position, blockFace, true);
            this.lastMinedPosition = position;
        } else {
            ItemMapping mapping = item.getMapping(this.session);
            ItemDefinition customItem = mapping.isTool() ? CustomItemTranslator.getCustomItem(this.session, item.getAmount(), item.getAllComponents(), mapping) : null;
            CustomBlockState blockStateOverride = (CustomBlockState)BlockRegistries.CUSTOM_BLOCK_STATE_OVERRIDES.get(state.javaId());
            SkullCache.Skull skull = this.session.getSkullCache().getSkulls().get(position);
            this.serverSideBlockBreaking = false;
            if (((BitSet)BlockRegistries.NON_VANILLA_BLOCK_IDS.get()).get(state.javaId()) || blockStateOverride != null || customItem != null || this.session.getItemMappings().getNonVanillaCustomItemIds().contains(item.getJavaId()) || skull != null && skull.getBlockDefinition() != null) {
                this.serverSideBlockBreaking = true;
            }
            LevelEventPacket startBreak = new LevelEventPacket();
            startBreak.setType((LevelEventType)LevelEvent.BLOCK_START_BREAK);
            startBreak.setPosition(position.toFloat());
            startBreak.setData((int)(65535.0 / BlockUtils.reciprocal(breakProgress)));
            this.session.sendUpstreamPacket((BedrockPacket)startBreak);
            BlockUtils.spawnBlockBreakParticles(this.session, blockFace, position, state);
            this.currentBlockFace = blockFace;
            this.currentBlockPos = position;
            this.currentBlockState = state;
            this.currentItemStack = item;
            this.currentProgress = breakProgress;
            this.session.sendDownstreamGamePacket((Packet)new ServerboundPlayerActionPacket(PlayerAction.START_DIGGING, position, blockFace.mcpl(), this.session.getWorldCache().nextPredictionSequence()));
        }
    }

    protected void handleContinueDestroy(@NonNull Vector3i position, @NonNull BlockState state, @NonNull Direction blockFace, boolean bedrockDestroyed, boolean sendParticles, long tick) {
        if (this.currentBlockState != null && Objects.equals(position, this.currentBlockPos) && this.sameItemStack()) {
            this.currentBlockFace = blockFace;
            float newProgress = this.calculateBreakProgress(state, position, this.session.getPlayerInventory().getItemInHand());
            this.currentProgress += newProgress;
            double totalBreakTime = BlockUtils.reciprocal(newProgress);
            if (sendParticles || this.serverSideBlockBreaking && this.currentProgress % 4.0f == 0.0f) {
                BlockUtils.spawnBlockBreakParticles(this.session, blockFace, position, state);
            }
            if (this.mayBreak(this.currentProgress, bedrockDestroyed)) {
                this.destroyBlock(state, position, blockFace, false);
                if (!bedrockDestroyed) {
                    this.lastMinedPosition = position;
                }
                return;
            }
            if (bedrockDestroyed) {
                BlockUtils.restoreCorrectBlock(this.session, position, state);
            }
            LevelEventPacket updateBreak = new LevelEventPacket();
            updateBreak.setType((LevelEventType)LevelEvent.BLOCK_UPDATE_BREAK);
            updateBreak.setPosition(position.toFloat());
            updateBreak.setData((int)(65535.0 / totalBreakTime));
            this.session.sendUpstreamPacket((BedrockPacket)updateBreak);
        } else {
            this.lastMinedPosition = null;
            if (this.currentBlockPos != null) {
                LevelEventPacket updateBreak = new LevelEventPacket();
                updateBreak.setType((LevelEventType)LevelEvent.BLOCK_UPDATE_BREAK);
                updateBreak.setPosition(position.toFloat());
                updateBreak.setData(0);
                this.session.sendUpstreamPacketImmediately((BedrockPacket)updateBreak);
                if (bedrockDestroyed) {
                    BlockUtils.restoreCorrectBlock(this.session, this.currentBlockPos, this.currentBlockState);
                }
                this.handleAbortBreaking(this.currentBlockPos);
            }
            this.handleStartBreak(position, state, blockFace, tick);
        }
    }

    protected void handlePredictDestroy(Vector3i position, BlockState state, Direction blockFace, long tick) {
        this.handleContinueDestroy(position, state, blockFace, true, true, tick);
    }

    private void handleAbortBreaking(Vector3i position) {
        if (this.currentBlockPos != null) {
            ServerboundPlayerActionPacket abortBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.CANCEL_DIGGING, this.currentBlockPos, Direction.DOWN.mcpl(), 0);
            this.session.sendDownstreamGamePacket((Packet)abortBreakingPacket);
        }
        BlockUtils.sendBedrockStopBlockBreak(this.session, position.toFloat());
        this.clearCurrentVariables();
    }

    protected boolean testForItemFrameEntity(Vector3i position) {
        if (this.itemFramePos != null && this.itemFramePos.equals(position)) {
            return true;
        }
        ItemFrameEntity itemFrameEntity = ItemFrameEntity.getItemFrameEntity(this.session, position);
        if (itemFrameEntity != null) {
            ServerboundInteractPacket attackPacket = new ServerboundInteractPacket(itemFrameEntity.getEntityId(), InteractAction.ATTACK, this.session.isSneaking());
            this.session.sendDownstreamGamePacket((Packet)attackPacket);
            this.itemFramePos = position;
            return true;
        }
        return false;
    }

    private boolean abortDueToBlockRestoring(Vector3i position) {
        if (this.restoredBlocks.contains(position)) {
            return true;
        }
        if (!this.restoredBlocks.isEmpty()) {
            BlockUtils.sendBedrockStopBlockBreak(this.session, position.toFloat());
            this.restoredBlocks.add(position);
            if (this.currentBlockPos != null && !Objects.equals(position, this.currentBlockPos)) {
                this.restoredBlocks.add(this.currentBlockPos);
                this.handleAbortBreaking(this.currentBlockPos);
            }
            return true;
        }
        return false;
    }

    protected boolean canBreak(Vector3i vector, BlockState state, PlayerActionType action) {
        if (this.session.isHandsBusy() || !this.session.getWorldBorder().isInsideBorderBoundaries()) {
            return false;
        }
        switch (this.session.getGameMode()) {
            case SPECTATOR: {
                return false;
            }
            case ADVENTURE: {
                if (this.blockPredicateCache.calculatePredicate(this.session, state, this.session.getPlayerInventory().getItemInHand())) break;
                return false;
            }
        }
        Vector3f playerPosition = this.session.getPlayerEntity().getPosition();
        playerPosition = playerPosition.down(EntityDefinitions.PLAYER.offset() - this.session.getEyeHeight());
        return BedrockInventoryTransactionTranslator.canInteractWithBlock(this.session, playerPosition, vector);
    }

    protected boolean canDestroyBlock(BlockState state) {
        ToolData data;
        boolean instabuild = this.session.isInstabuild();
        if (instabuild && (data = (ToolData)this.session.getPlayerInventory().getItemInHand().getComponent(DataComponentTypes.TOOL)) != null && !data.isCanDestroyBlocksInCreative()) {
            return false;
        }
        if (((List)Registries.GAME_MASTER_BLOCKS.get()).contains(state.block().javaIdentifier()) && (!instabuild || this.session.getOpPermissionLevel() < 2)) {
            return false;
        }
        return !state.is(Blocks.AIR);
    }

    protected boolean mayBreak(float progress, boolean bedrockDestroyed) {
        return this.serverSideBlockBreaking && progress >= 1.0f || bedrockDestroyed && progress >= 0.65f;
    }

    protected void destroyBlock(BlockState state, Vector3i vector, Direction direction, boolean instamine) {
        this.session.sendDownstreamGamePacket((Packet)new ServerboundPlayerActionPacket(instamine ? PlayerAction.START_DIGGING : PlayerAction.FINISH_DIGGING, vector, direction.mcpl(), this.session.getWorldCache().nextPredictionSequence()));
        this.session.getWorldCache().markPositionInSequence(vector);
        if (this.canDestroyBlock(state)) {
            BlockUtils.spawnBlockBreakParticles(this.session, direction, vector, state);
            BlockUtils.sendBedrockBlockDestroy(this.session, vector.toFloat(), state.javaId());
        } else {
            BlockUtils.restoreCorrectBlock(this.session, vector, state);
        }
        this.clearCurrentVariables();
    }

    protected float calculateBreakProgress(BlockState state, Vector3i vector, GeyserItemStack stack) {
        return BlockUtils.getBlockMiningProgressPerTick(this.session, state.block(), stack);
    }

    protected boolean testForLastBreakPosOrReset(Vector3i position) {
        if (Objects.equals(this.lastMinedPosition, position)) {
            return true;
        }
        this.lastMinedPosition = null;
        return false;
    }

    private boolean sameItemStack() {
        if (this.currentItemStack == null) {
            return false;
        }
        GeyserItemStack stack = this.session.getPlayerInventory().getItemInHand();
        if (this.currentItemStack.isEmpty() && stack.isEmpty()) {
            return true;
        }
        if (this.currentItemStack.getJavaId() != stack.getJavaId()) {
            return false;
        }
        return Objects.equals(stack.getComponents(), this.currentItemStack.getComponents());
    }

    private @NonNull BlockState getCurrentBlockState(Vector3i position) {
        if (Objects.equals(position, this.currentBlockPos)) {
            if (this.updatedServerBlockStateId != null) {
                BlockState updated = BlockState.of(this.updatedServerBlockStateId);
                this.updatedServerBlockStateId = null;
                return updated;
            }
            if (this.currentBlockState != null) {
                return this.currentBlockState;
            }
        }
        this.updatedServerBlockStateId = null;
        return this.session.getGeyser().getWorldManager().blockAt(this.session, position);
    }

    protected void clearCurrentVariables() {
        this.currentBlockPos = null;
        this.currentBlockState = null;
        this.currentBlockFace = null;
        this.currentProgress = 0.0f;
        this.currentItemStack = null;
        this.updatedServerBlockStateId = null;
    }

    public void reset() {
        this.clearCurrentVariables();
        this.lastMinedPosition = null;
        this.destructionStageCache.invalidateAll();
    }

    @Generated
    public @Nullable Vector3i getCurrentBlockPos() {
        return this.currentBlockPos;
    }

    @Generated
    public void setUpdatedServerBlockStateId(@Nullable Integer updatedServerBlockStateId) {
        this.updatedServerBlockStateId = updatedServerBlockStateId;
    }

    @Generated
    public Cache<Vector3i, Pair<Long, BlockBreakStage>> getDestructionStageCache() {
        return this.destructionStageCache;
    }

    private static class BlockPredicateCache {
        private BlockState lastBlockState;
        private GeyserItemStack lastItemStack;
        private Boolean lastResult;

        private BlockPredicateCache() {
        }

        private boolean calculatePredicate(GeyserSession session, BlockState state, GeyserItemStack stack) {
            if (stack.isEmpty()) {
                return false;
            }
            AdventureModePredicate canBreak = (AdventureModePredicate)stack.getComponent(DataComponentTypes.CAN_BREAK);
            if (canBreak == null) {
                return false;
            }
            if (state.equals(this.lastBlockState) && stack.equals(this.lastItemStack) && this.lastResult != null) {
                return this.lastResult;
            }
            this.lastBlockState = state;
            this.lastItemStack = stack;
            for (AdventureModePredicate.BlockPredicate predicate : canBreak.getPredicates()) {
                if (!BlockUtils.blockMatchesPredicate(session, state, predicate)) continue;
                this.lastResult = true;
                return this.lastResult;
            }
            this.lastResult = false;
            return this.lastResult;
        }
    }
}

