/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtUtils;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemCategory;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.CreativeItemGroup;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.populator.ItemRegistryPopulator;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.registry.type.GeyserMappingItem;
import org.geysermc.geyser.util.JsonUtils;

public class CreativeItemRegistryPopulator {
    private static final List<BiPredicate<String, Integer>> JAVA_ONLY_ITEM_FILTER = List.of((identifier, data) -> identifier.equals("minecraft:empty_map") && data == 2);

    static void readCreativeItemGroups(ItemRegistryPopulator.PaletteVersion palette, List<CreativeItemData> creativeItemData, List<CreativeItemGroup> creativeItemGroups, Map<String, Integer> groupIndexMap, Map<CreativeItemCategory, Integer> lastCreativeItemGroup) {
        JsonArray creativeItemEntries;
        GeyserBootstrap bootstrap = GeyserImpl.getInstance().getBootstrap();
        try (InputStream stream = bootstrap.getResourceOrThrow(String.format("bedrock/creative_items.%s.json", palette.version()));){
            creativeItemEntries = JsonUtils.fromJson(stream).getAsJsonArray("groups");
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load creative item groups", e);
        }
        for (JsonElement creativeItemEntry : creativeItemEntries) {
            JsonObject creativeItemEntryObject = creativeItemEntry.getAsJsonObject();
            CreativeItemCategory category = CreativeItemCategory.valueOf((String)creativeItemEntryObject.get("category").getAsString().toUpperCase(Locale.ROOT));
            String name = creativeItemEntryObject.get("name").getAsString();
            JsonElement icon = creativeItemEntryObject.get("icon");
            String identifier = icon.getAsJsonObject().get("id").getAsString();
            ItemData itemData = identifier.equals("minecraft:air") ? ItemData.AIR : creativeItemData.stream().map(CreativeItemData::getItem).filter(item -> item.getDefinition().getIdentifier().equals(identifier)).findFirst().orElseThrow();
            if (!name.isEmpty()) {
                groupIndexMap.put(name, creativeItemGroups.size());
            }
            creativeItemGroups.add(new CreativeItemGroup(category, name, itemData));
        }
        CreativeItemCategory category = null;
        for (int i = 0; i < creativeItemGroups.size(); ++i) {
            CreativeItemGroup creativeItemGroup = creativeItemGroups.get(i);
            if (category == null) {
                category = creativeItemGroup.getCategory();
            }
            if (creativeItemGroup.getCategory() != category) {
                lastCreativeItemGroup.put(category, i - 1);
                category = creativeItemGroup.getCategory();
            }
            if (i != creativeItemGroups.size() - 1) continue;
            lastCreativeItemGroup.put(creativeItemGroup.getCategory(), i);
        }
    }

    static void populate(ItemRegistryPopulator.PaletteVersion palette, Map<String, ItemDefinition> definitions, Map<String, GeyserMappingItem> items, BiConsumer<ItemData.Builder, Integer> itemConsumer) {
        JsonArray creativeItemEntries;
        GeyserBootstrap bootstrap = GeyserImpl.getInstance().getBootstrap();
        try (InputStream stream = bootstrap.getResourceOrThrow(String.format("bedrock/creative_items.%s.json", palette.version()));){
            creativeItemEntries = JsonUtils.fromJson(stream).getAsJsonArray("items");
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load creative items", e);
        }
        BlockMappings blockMappings = BlockRegistries.BLOCKS.forVersion(palette.protocolVersion());
        for (JsonElement itemNode : creativeItemEntries) {
            ItemData.Builder itemBuilder = CreativeItemRegistryPopulator.createItemData((JsonObject)itemNode, items, blockMappings, definitions);
            if (itemBuilder == null) continue;
            JsonElement groupIdElement = itemNode.getAsJsonObject().get("groupId");
            int groupId = groupIdElement != null ? groupIdElement.getAsInt() : 0;
            itemConsumer.accept(itemBuilder, groupId);
        }
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ItemData.Builder createItemData(JsonObject itemNode, Map<String, GeyserMappingItem> items, BlockMappings blockMappings, Map<String, ItemDefinition> definitions) {
        ItemDefinition definition;
        JsonElement nbtNode;
        JsonElement countNode;
        JsonElement damageNode;
        int count = 1;
        int damage = 0;
        NbtMap tag = null;
        String identifier = itemNode.get("id").getAsString();
        for (BiPredicate<String, Integer> predicate : JAVA_ONLY_ITEM_FILTER) {
            if (!predicate.test(identifier, damage)) continue;
            return null;
        }
        if (!items.containsKey(identifier) && !identifier.equals("minecraft:lodestone_compass")) {
            boolean found = false;
            for (GeyserMappingItem mapping : items.values()) {
                if (!mapping.getBedrockIdentifier().equals(identifier)) continue;
                found = true;
                break;
            }
        }
        if ((damageNode = itemNode.get("damage")) != null) {
            damage = damageNode.getAsInt();
        }
        if ((countNode = itemNode.get("count")) != null) {
            count = countNode.getAsInt();
        }
        GeyserBedrockBlock blockDefinition = null;
        JsonElement blockStateNode = itemNode.get("block_state_b64");
        if (blockStateNode != null) {
            byte[] bytes = Base64.getDecoder().decode(blockStateNode.getAsString());
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try {
                NbtMap stateTag = (NbtMap)NbtUtils.createReaderLE((InputStream)bais).readTag();
                NbtMapBuilder builder = stateTag.toBuilder();
                builder.remove((Object)"name_hash");
                builder.remove((Object)"network_id");
                builder.remove((Object)"version");
                builder.remove((Object)"block_id");
                blockDefinition = blockMappings.getDefinition(builder.build());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((nbtNode = itemNode.get("nbt_b64")) != null) {
            byte[] bytes = Base64.getDecoder().decode(nbtNode.getAsString());
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try {
                tag = (NbtMap)NbtUtils.createReaderLE((InputStream)bais).readTag();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((definition = definitions.get(identifier)) == null) {
            GeyserImpl.getInstance().getLogger().debug("Unknown item definition with identifier " + identifier + " when loading creative items!");
            return null;
        }
        return ItemData.builder().definition(definition).damage(damage).count(count).tag(tag).blockDefinition(blockDefinition);
    }
}

