/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.components.readers;

import com.google.gson.JsonElement;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaItemDataComponents;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaUseCooldown;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.item.custom.impl.JavaUseCooldownImpl;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.registry.mappings.components.DataComponentReader;
import org.geysermc.geyser.registry.mappings.util.MappingsUtil;
import org.geysermc.geyser.registry.mappings.util.NodeReader;

public class UseCooldownReader
extends DataComponentReader<JavaUseCooldown> {
    public UseCooldownReader() {
        super(JavaItemDataComponents.USE_COOLDOWN);
    }

    @Override
    protected JavaUseCooldown readDataComponent(@NonNull JsonElement element, String ... context) throws InvalidCustomMappingsFileException {
        float seconds = MappingsUtil.readOrThrow(element, "seconds", NodeReader.POSITIVE_DOUBLE.andThen(Double::floatValue), context).floatValue();
        Identifier cooldownGroup = MappingsUtil.readOrDefault(element, "cooldown_group", NodeReader.IDENTIFIER, null, context);
        return new JavaUseCooldownImpl(seconds, cooldownGroup);
    }
}

