/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.components.readers;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaItemDataComponents;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.registry.mappings.components.DataComponentReader;
import org.geysermc.geyser.registry.mappings.util.MappingsUtil;
import org.geysermc.geyser.registry.mappings.util.NodeReader;

public class EnchantableReader
extends DataComponentReader<Integer> {
    public EnchantableReader() {
        super(JavaItemDataComponents.ENCHANTABLE);
    }

    @Override
    protected Integer readDataComponent(@NonNull JsonElement element, String ... context) throws InvalidCustomMappingsFileException {
        try {
            if (element instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)element;
                return NodeReader.NON_NEGATIVE_INT.read(primitive, "reading component", context);
            }
        }
        catch (InvalidCustomMappingsFileException invalidCustomMappingsFileException) {
            // empty catch block
        }
        return MappingsUtil.readOrThrow(element, "value", NodeReader.NON_NEGATIVE_INT, new String[0]);
    }
}

