/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.components.readers;

import com.google.gson.JsonElement;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaAttackRange;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaItemDataComponents;
import org.geysermc.geyser.item.custom.impl.JavaAttackRangeImpl;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.registry.mappings.components.DataComponentReader;
import org.geysermc.geyser.registry.mappings.util.MappingsUtil;
import org.geysermc.geyser.registry.mappings.util.NodeReader;

public class AttackRangeReader
extends DataComponentReader<JavaAttackRange> {
    private static final NodeReader<Float> REACH_READER = NodeReader.boundedDouble(0.0, 64.0).andThen(Double::floatValue);

    public AttackRangeReader() {
        super(JavaItemDataComponents.ATTACK_RANGE);
    }

    @Override
    protected JavaAttackRange readDataComponent(@NonNull JsonElement element, String ... context) throws InvalidCustomMappingsFileException {
        return new JavaAttackRangeImpl(MappingsUtil.readOrDefault(element, "min_reach", REACH_READER, Float.valueOf(0.0f), context).floatValue(), MappingsUtil.readOrDefault(element, "max_reach", REACH_READER, Float.valueOf(3.0f), context).floatValue(), MappingsUtil.readOrDefault(element, "min_creative_reach", REACH_READER, Float.valueOf(0.0f), context).floatValue(), MappingsUtil.readOrDefault(element, "max_creative_reach", REACH_READER, Float.valueOf(5.0f), context).floatValue(), MappingsUtil.readOrDefault(element, "hitbox_margin", NodeReader.boundedDouble(0.0, 1.0).andThen(Double::floatValue), Float.valueOf(0.3f), context).floatValue());
    }
}

