/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.geysermc.geyser.registry.IRegistry;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.geyser.registry.loader.RegistryLoaders;

class DeferredRegistry<M, R extends IRegistry<M>>
implements IRegistry<M> {
    private final R backingRegistry;
    private final Supplier<M> loader;
    private boolean loaded;

    protected <I> DeferredRegistry(Function<RegistryLoader<I, M>, R> registryLoader, RegistryLoader<I, M> deferredLoader) {
        this.backingRegistry = (IRegistry)registryLoader.apply(RegistryLoaders.uninitialized());
        this.loader = () -> deferredLoader.load(null);
    }

    protected <I> DeferredRegistry(Function<RegistryLoader<I, M>, R> registryLoader, Supplier<RegistryLoader<I, M>> deferredLoader) {
        this.backingRegistry = (IRegistry)registryLoader.apply(RegistryLoaders.uninitialized());
        this.loader = () -> ((RegistryLoader)deferredLoader.get()).load(null);
    }

    protected <I> DeferredRegistry(I input, RegistryInitializer<M, R> registryInitializer, RegistryLoader<I, M> deferredLoader) {
        this.backingRegistry = registryInitializer.initialize(input, RegistryLoaders.uninitialized());
        this.loader = () -> deferredLoader.load(input);
    }

    protected <I> DeferredRegistry(I input, RegistryInitializer<M, R> registryInitializer, Supplier<RegistryLoader<I, M>> deferredLoader) {
        this.backingRegistry = registryInitializer.initialize(input, RegistryLoaders.uninitialized());
        this.loader = () -> ((RegistryLoader)deferredLoader.get()).load(input);
    }

    protected R backingRegistry() {
        return this.backingRegistry;
    }

    @Override
    public M get() {
        if (!this.loaded) {
            throw new IllegalStateException("Registry has not been loaded yet!");
        }
        return this.backingRegistry.get();
    }

    @Override
    public void set(M mappings) {
        this.backingRegistry.set(mappings);
    }

    @Override
    public void register(Consumer<M> consumer) {
        if (!this.loaded) {
            throw new IllegalStateException("Registry has not been loaded yet!");
        }
        this.backingRegistry.register(consumer);
    }

    public void load() {
        this.backingRegistry.set(this.loader.get());
        this.loaded = true;
    }

    public boolean loaded() {
        return this.loaded;
    }

    public static interface RegistryInitializer<M, R extends IRegistry<M>> {
        public <I> R initialize(I var1, RegistryLoader<I, M> var2);
    }
}

