/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.mod;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.channel.ChannelFutureListener;
import java.net.InetSocketAddress;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerStatusPacketListenerImpl;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.ping.GeyserPingInfo;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;

public class ModPingPassthrough
implements IGeyserPingPassthrough {
    private final MinecraftServer server;
    private final GeyserLogger logger;

    @Override
    public @Nullable GeyserPingInfo getPingInformation(InetSocketAddress inetSocketAddress) {
        ServerStatus status;
        block3: {
            status = this.server.getStatus();
            if (status == null) {
                return null;
            }
            try {
                StatusInterceptor connection = new StatusInterceptor();
                ServerStatusPacketListenerImpl statusPacketListener = new ServerStatusPacketListenerImpl(status, (Connection)connection);
                statusPacketListener.handleStatusRequest(ServerboundStatusRequestPacket.INSTANCE);
                status = Objects.requireNonNull(connection.status, "status response");
            }
            catch (Exception e) {
                if (!this.logger.isDebug()) break block3;
                this.logger.debug("Failed to listen for modified ServerStatus: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return new GeyserPingInfo(((JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.server.registryAccess()), (Object)status.description()).getOrThrow()).toString(), status.players().map(ServerStatus.Players::max).orElse(1), status.players().map(ServerStatus.Players::online).orElse(0));
    }

    @Generated
    public ModPingPassthrough(MinecraftServer server, GeyserLogger logger) {
        this.server = server;
        this.logger = logger;
    }

    private static class StatusInterceptor
    extends Connection {
        ServerStatus status;

        StatusInterceptor() {
            super(PacketFlow.SERVERBOUND);
        }

        public void send(Packet<?> packet, @Nullable ChannelFutureListener channelFutureListener, boolean bl) {
            if (packet instanceof ClientboundStatusResponsePacket) {
                ClientboundStatusResponsePacket statusResponse = (ClientboundStatusResponsePacket)packet;
                this.status = statusResponse.status();
            }
            super.send(packet, channelFutureListener, bl);
        }
    }
}

