/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.pack.option;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.exception.ResourcePackException;
import org.geysermc.geyser.api.pack.option.PriorityOption;
import org.geysermc.geyser.api.pack.option.ResourcePackOption;

public record GeyserPriorityOption(int priority) implements PriorityOption
{
    @Override
    public @NonNull ResourcePackOption.Type type() {
        return ResourcePackOption.Type.PRIORITY;
    }

    @Override
    public @NonNull Integer value() {
        return this.priority;
    }

    @Override
    public void validate(@NonNull ResourcePack pack) {
        Objects.requireNonNull(pack);
        if (this.priority < -100 || this.priority > 100) {
            throw new ResourcePackException(ResourcePackException.Cause.INVALID_PACK_OPTION, "Priority must be between -100 and 100 inclusive!");
        }
    }
}

