/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import java.util.List;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.item.components.resolvable.ResolvableComponent;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.cache.ComponentCache;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.jetbrains.annotations.UnmodifiableView;

public class NonVanillaItem
extends Item {
    private final @NonNull List<ResolvableComponent<?>> resolvableComponents;
    private final @NonNull List<? extends DataComponentType<?>> resolvableComponentTypes;

    public NonVanillaItem(String javaIdentifier, Item.Builder builder, @NonNull List<ResolvableComponent<?>> resolvableComponents) {
        super(javaIdentifier, builder);
        this.resolvableComponents = resolvableComponents;
        this.resolvableComponentTypes = resolvableComponents.stream().map(ResolvableComponent::type).toList();
    }

    @Override
    public @NonNull @UnmodifiableView DataComponents gatherComponents(@Nullable ComponentCache componentCache, @Nullable DataComponents others) {
        if (this.resolvableComponents.isEmpty()) {
            return super.gatherComponents(componentCache, others);
        }
        if (componentCache == null) {
            GeyserImpl.getInstance().getLogger().debug("Unable to resolve components for non-vanilla item because componentCache is null");
            return super.gatherComponents(null, others);
        }
        DataComponents resolvedAndOthers = componentCache.getResolvedComponents(this).clone();
        if (others != null) {
            resolvedAndOthers.getDataComponents().putAll(others.getDataComponents());
        }
        return super.gatherComponents(componentCache, resolvedAndOthers);
    }

    @Override
    public <T> @Nullable T getComponent(@Nullable ComponentCache componentCache, @NonNull DataComponentType<T> type) {
        if (this.resolvableComponentTypes.contains(type)) {
            if (componentCache == null) {
                GeyserImpl.getInstance().getLogger().debug("Unable to resolve components for non-vanilla item because componentCache is null");
                return super.getComponent(null, type);
            }
            return (T)componentCache.getResolvedComponents(this).get(type);
        }
        return super.getComponent(componentCache, type);
    }

    @Generated
    public @NonNull List<ResolvableComponent<?>> resolvableComponents() {
        return this.resolvableComponents;
    }
}

