/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.item.TooltipOptions;
import org.geysermc.geyser.item.type.BedrockRequiresTagItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.FireworkColor;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Fireworks;

public class FireworkRocketItem
extends Item
implements BedrockRequiresTagItem {
    public FireworkRocketItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull TooltipOptions tooltip, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, tooltip, builder);
        Fireworks fireworks = (Fireworks)components.get(DataComponentTypes.FIREWORKS);
        if (fireworks == null) {
            return;
        }
        NbtMapBuilder fireworksNbt = NbtMap.builder();
        fireworksNbt.putByte("Flight", (byte)fireworks.getFlightDuration());
        List explosions = fireworks.getExplosions();
        if (!explosions.isEmpty()) {
            ArrayList<NbtMap> explosionNbt = new ArrayList<NbtMap>();
            for (Fireworks.FireworkExplosion explosion : explosions) {
                explosionNbt.add(FireworkRocketItem.translateExplosionToBedrock(explosion));
            }
            fireworksNbt.putList("Explosions", NbtType.COMPOUND, explosionNbt);
        } else {
            fireworksNbt.put("Explosions", (Object)NbtList.EMPTY);
        }
        builder.putCompound("Fireworks", fireworksNbt.build());
    }

    @Override
    public void translateNbtToJava(@NonNull GeyserSession session, @NonNull NbtMap bedrockTag, @NonNull DataComponents components, @NonNull ItemMapping mapping) {
        List explosions;
        super.translateNbtToJava(session, bedrockTag, components, mapping);
        NbtMap fireworksTag = bedrockTag.getCompound("Fireworks");
        if (!fireworksTag.isEmpty() && !(explosions = fireworksTag.getList("Explosions", NbtType.COMPOUND)).isEmpty()) {
            ArrayList<Fireworks.FireworkExplosion> javaExplosions = new ArrayList<Fireworks.FireworkExplosion>();
            for (NbtMap explosion : explosions) {
                Fireworks.FireworkExplosion javaExplosion = FireworkRocketItem.translateExplosionToJava(explosion);
                if (javaExplosion == null) continue;
                javaExplosions.add(javaExplosion);
            }
            components.put(DataComponentTypes.FIREWORKS, (Object)new Fireworks(1, javaExplosions));
        }
    }

    static NbtMap translateExplosionToBedrock(Fireworks.FireworkExplosion explosion) {
        NbtMapBuilder newExplosionData = NbtMap.builder();
        newExplosionData.putByte("FireworkType", (byte)explosion.getShapeId());
        int[] oldColors = explosion.getColors();
        byte[] colors = new byte[oldColors.length];
        int i = 0;
        for (int color : oldColors) {
            colors[i++] = FireworkColor.fromJavaRGB(color);
        }
        newExplosionData.putByteArray("FireworkColor", colors);
        oldColors = explosion.getFadeColors();
        colors = new byte[oldColors.length];
        i = 0;
        for (int color : oldColors) {
            colors[i++] = FireworkColor.fromJavaRGB(color);
        }
        newExplosionData.putByteArray("FireworkFade", colors);
        newExplosionData.putBoolean("FireworkTrail", explosion.isHasTrail());
        newExplosionData.putBoolean("FireworkFlicker", explosion.isHasTwinkle());
        return newExplosionData.build();
    }

    static Fireworks.FireworkExplosion translateExplosionToJava(NbtMap explosion) {
        byte[] javaColors = explosion.getByteArray("FireworkColor", null);
        if (javaColors != null) {
            int[] colors = new int[javaColors.length];
            int i = 0;
            for (byte color : javaColors) {
                colors[i++] = FireworkColor.fromBedrockId(color);
            }
            return new Fireworks.FireworkExplosion(0, colors, IntArrays.EMPTY_ARRAY, false, false);
        }
        return null;
    }
}

