/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.TrimMaterial;
import org.cloudburstmc.protocol.bedrock.data.TrimPattern;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.item.TooltipOptions;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ArmorTrim;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public class ArmorItem
extends Item {
    public ArmorItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull TooltipOptions tooltip, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, tooltip, builder);
        ArmorTrim trim = (ArmorTrim)components.get(DataComponentTypes.TRIM);
        if (trim != null) {
            if (!trim.material().isId()) {
                GeyserImpl.getInstance().getLogger().debug("Unable to translate non-id trim material: " + String.valueOf(trim));
                return;
            }
            TrimMaterial material = session.getRegistryCache().registry(JavaRegistries.TRIM_MATERIAL).byId(trim.material().id());
            if (!trim.pattern().isId()) {
                GeyserImpl.getInstance().getLogger().debug("Unable to translate non-id trim pattern: " + String.valueOf(trim));
                return;
            }
            TrimPattern pattern = session.getRegistryCache().registry(JavaRegistries.TRIM_PATTERN).byId(trim.pattern().id());
            if (material != null && pattern != null) {
                NbtMapBuilder trimBuilder = NbtMap.builder();
                String materialId = material.getMaterialId();
                String patternId = pattern.getPatternId();
                int colonIdx = materialId.indexOf(58);
                if (colonIdx >= 0) {
                    materialId = materialId.substring(colonIdx + 1);
                }
                if ((colonIdx = patternId.indexOf(58)) >= 0) {
                    patternId = patternId.substring(colonIdx + 1);
                }
                trimBuilder.put("Material", (Object)materialId);
                trimBuilder.put("Pattern", (Object)patternId);
                builder.putCompound("Trim", trimBuilder.build());
            } else {
                GeyserImpl.getInstance().getLogger().debug("Unknown trim material/pattern: ", trim);
            }
        }
    }
}

