/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom.impl.predicates;

import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.predicate.MinecraftPredicate;
import org.geysermc.geyser.api.predicate.context.item.ItemPredicateContext;
import org.geysermc.geyser.api.predicate.item.CustomModelDataPredicate;
import org.geysermc.geyser.impl.GeyserCoreProvided;

public final class GeyserCustomModelDataPredicate {

    @GeyserCoreProvided
    public record GeyserStringPredicate(@Nullable String string, @NonNegative int index, boolean negated) implements CustomModelDataPredicate.StringPredicate
    {
        public GeyserStringPredicate(@Nullable String string, @NonNegative int index, boolean negated) {
            if (index < 0) {
                throw new IllegalArgumentException("Negative index: " + index);
            }
        }

        @Override
        public boolean test(ItemPredicateContext context) {
            return this.negated != Objects.equals(this.string, context.customModelDataString(this.index));
        }

        @Override
        public @NonNull MinecraftPredicate<ItemPredicateContext> negate() {
            return new GeyserStringPredicate(this.string, this.index, !this.negated);
        }
    }

    @GeyserCoreProvided
    public record GeyserFlagPredicate(@NonNegative int index, boolean negated) implements CustomModelDataPredicate.FlagPredicate
    {
        public GeyserFlagPredicate(@NonNegative int index, boolean negated) {
            if (index < 0) {
                throw new IllegalArgumentException("Negative index: " + index);
            }
        }

        @Override
        public boolean test(ItemPredicateContext context) {
            return this.negated != context.customModelDataFlag(this.index);
        }

        @Override
        public @NonNull MinecraftPredicate<ItemPredicateContext> negate() {
            return new GeyserFlagPredicate(this.index, !this.negated);
        }
    }
}

