/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom.impl;

import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaKineticWeapon;

public record JavaKineticWeaponImpl(@NonNegative int delayTicks, @Nullable JavaKineticWeapon.Condition dismountConditions) implements JavaKineticWeapon
{

    public record ConditionImpl(@NonNegative int maxDurationTicks, float minSpeed, float minRelativeSpeed) implements JavaKineticWeapon.Condition
    {

        public static class Builder
        implements JavaKineticWeapon.Condition.Builder {
            private final int maxDurationTicks;
            private float minSpeed = 0.0f;
            private float minRelativeSpeed = 0.0f;

            public Builder(int maxDurationTicks) {
                if (maxDurationTicks < 0) {
                    throw new IllegalArgumentException("max duration ticks must not be negative");
                }
                this.maxDurationTicks = maxDurationTicks;
            }

            @Override
            public Builder minSpeed(float minSpeed) {
                this.minSpeed = minSpeed;
                return this;
            }

            @Override
            public Builder minRelativeSpeed(float minRelativeSpeed) {
                this.minRelativeSpeed = minRelativeSpeed;
                return this;
            }

            @Override
            public JavaKineticWeapon.Condition build() {
                return new ConditionImpl(this.maxDurationTicks, this.minSpeed, this.minRelativeSpeed);
            }
        }
    }

    public static class Builder
    implements JavaKineticWeapon.Builder {
        private int delayTicks = 0;
        private JavaKineticWeapon.Condition dismountConditions = null;

        @Override
        public Builder delayTicks(int delayTicks) {
            if (delayTicks < 0) {
                throw new IllegalArgumentException("delay ticks must not be negative");
            }
            this.delayTicks = delayTicks;
            return this;
        }

        @Override
        public Builder dismountConditions(@Nullable JavaKineticWeapon.Condition dismountConditions) {
            this.dismountConditions = dismountConditions;
            return this;
        }

        @Override
        public JavaKineticWeapon build() {
            return new JavaKineticWeaponImpl(this.delayTicks, this.dismountConditions);
        }
    }
}

