/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.item.custom.v2.component.geyser.GeyserChargeable;
import org.geysermc.geyser.api.util.Identifier;

public record GeyserChargeableImpl(@NonNegative float maxDrawDuration, boolean chargeOnDraw, @NonNull List<@NonNull Identifier> ammunition) implements GeyserChargeable
{

    public static class Builder
    implements GeyserChargeable.Builder {
        private float maxDrawDuration;
        private boolean chargeOnDraw;
        private final List<Identifier> ammunition = new ArrayList<Identifier>();

        @Override
        public GeyserChargeable.Builder maxDrawDuration(@NonNegative float maxDrawDuration) {
            if (maxDrawDuration < 0.0f) {
                throw new IllegalArgumentException("maxDrawDuration must be positive");
            }
            this.maxDrawDuration = maxDrawDuration;
            return this;
        }

        @Override
        public GeyserChargeable.Builder chargeOnDraw(boolean chargeOnDraw) {
            this.chargeOnDraw = chargeOnDraw;
            return this;
        }

        @Override
        public GeyserChargeable.Builder ammunition(@NonNull Identifier ammunition) {
            Objects.requireNonNull(ammunition, "ammunition cannot be null");
            if (this.ammunition.contains(ammunition)) {
                throw new IllegalArgumentException("duplicate ammunition " + String.valueOf(ammunition));
            }
            this.ammunition.add(ammunition);
            return this;
        }

        @Override
        public GeyserChargeable build() {
            Objects.requireNonNull(this.ammunition, "ammunition cannot be null");
            return new GeyserChargeableImpl(this.maxDrawDuration, this.chargeOnDraw, List.copyOf(this.ammunition));
        }
    }
}

