/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.item.custom.v2.CustomItemBedrockOptions;
import org.geysermc.geyser.api.util.CreativeCategory;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.registry.populator.custom.CustomItemContext;
import org.jetbrains.annotations.NotNull;

public record GeyserCustomItemBedrockOptions(@Nullable String icon, boolean allowOffhand, boolean displayHandheld, int protectionValue, @NonNull CreativeCategory creativeCategory, @Nullable String creativeGroup, @NonNull Set<Identifier> tags) implements CustomItemBedrockOptions
{
    private final int protectionValue;

    @Override
    public int protectionValue() {
        return this.protectionValue == -1 ? 0 : this.protectionValue;
    }

    public int protectionValue(CustomItemContext context) {
        if (this.protectionValue == -1 && context.vanillaMapping().isPresent()) {
            return context.vanillaMapping().get().getProtectionValue();
        }
        return this.protectionValue();
    }

    public static class Builder
    implements CustomItemBedrockOptions.Builder {
        private String icon = null;
        private boolean allowOffhand = true;
        private boolean displayHandheld = false;
        private int protectionValue = -1;
        private CreativeCategory creativeCategory = CreativeCategory.NONE;
        private String creativeGroup = null;
        private Set<Identifier> tags = new HashSet<Identifier>();

        @Override
        public Builder icon(@Nullable String icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public Builder allowOffhand(boolean allowOffhand) {
            this.allowOffhand = allowOffhand;
            return this;
        }

        @Override
        public Builder displayHandheld(boolean displayHandheld) {
            this.displayHandheld = displayHandheld;
            return this;
        }

        @Override
        public Builder protectionValue(int protectionValue) {
            this.protectionValue = protectionValue;
            return this;
        }

        @Override
        public Builder creativeCategory(@NotNull CreativeCategory creativeCategory) {
            Objects.requireNonNull(creativeCategory, "creativeCategory cannot be null");
            this.creativeCategory = creativeCategory;
            return this;
        }

        @Override
        public Builder creativeGroup(@Nullable String creativeGroup) {
            this.creativeGroup = creativeGroup;
            return this;
        }

        @Override
        public CustomItemBedrockOptions.Builder tag(@NotNull Identifier tag) {
            Objects.requireNonNull(tag, "tag cannot be null");
            this.tags.add(tag);
            return this;
        }

        @Override
        public Builder tags(@Nullable Set<Identifier> tags) {
            this.tags = Objects.requireNonNullElseGet(tags, HashSet::new);
            return this;
        }

        @Override
        public CustomItemBedrockOptions build() {
            return new GeyserCustomItemBedrockOptions(this.icon, this.allowOffhand, this.displayHandheld, this.protectionValue, this.creativeCategory, this.creativeGroup, Set.copyOf(this.tags));
        }
    }
}

