/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item;

import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.item.custom.CustomItemData;
import org.geysermc.geyser.api.item.custom.CustomItemOptions;
import org.geysermc.geyser.api.item.custom.CustomRenderOffsets;
import org.geysermc.geyser.api.item.custom.v2.CustomItemBedrockOptions;
import org.geysermc.geyser.api.item.custom.v2.CustomItemDefinition;
import org.geysermc.geyser.api.predicate.MinecraftPredicate;
import org.geysermc.geyser.api.predicate.context.item.ItemPredicateContext;
import org.geysermc.geyser.api.predicate.item.ItemConditionPredicate;
import org.geysermc.geyser.api.predicate.item.ItemRangeDispatchPredicate;
import org.geysermc.geyser.api.util.CreativeCategory;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.item.custom.GeyserCustomItemDefinition;

@Deprecated
public class GeyserCustomItemData
implements CustomItemData {
    private final String name;
    private final CustomItemOptions customItemOptions;
    private final String displayName;
    private final String icon;
    private final boolean allowOffhand;
    private final boolean displayHandheld;
    private final OptionalInt creativeCategory;
    private final String creativeGroup;
    private final int textureSize;
    private final CustomRenderOffsets renderOffsets;
    private final Set<String> tags;

    public GeyserCustomItemData(String name, CustomItemOptions customItemOptions, String displayName, String icon, boolean allowOffhand, boolean displayHandheld, OptionalInt creativeCategory, String creativeGroup, int textureSize, CustomRenderOffsets renderOffsets, Set<String> tags) {
        this.name = name;
        this.customItemOptions = customItemOptions;
        this.displayName = displayName;
        this.icon = icon;
        this.allowOffhand = allowOffhand;
        this.displayHandheld = displayHandheld;
        this.creativeCategory = creativeCategory;
        this.creativeGroup = creativeGroup;
        this.textureSize = textureSize;
        this.renderOffsets = renderOffsets;
        this.tags = tags;
    }

    @Override
    public @NonNull String name() {
        return this.name;
    }

    @Override
    public CustomItemOptions customItemOptions() {
        return this.customItemOptions;
    }

    @Override
    public @NonNull String displayName() {
        return this.displayName;
    }

    @Override
    public @NonNull String icon() {
        return this.icon;
    }

    @Override
    public boolean allowOffhand() {
        return this.allowOffhand;
    }

    @Override
    public boolean displayHandheld() {
        return this.displayHandheld;
    }

    @Override
    public @NonNull OptionalInt creativeCategory() {
        return this.creativeCategory;
    }

    @Override
    public @Nullable String creativeGroup() {
        return this.creativeGroup;
    }

    @Override
    public int textureSize() {
        return this.textureSize;
    }

    @Override
    public CustomRenderOffsets renderOffsets() {
        return this.renderOffsets;
    }

    @Override
    public @NonNull Set<String> tags() {
        return this.tags;
    }

    public CustomItemDefinition.Builder toDefinition(Identifier javaItem) {
        GeyserCustomItemDefinition.Builder definition = (GeyserCustomItemDefinition.Builder)CustomItemDefinition.builder(Identifier.of("geyser_custom", this.name().toLowerCase(Locale.ROOT)), javaItem).displayName(this.displayName()).bedrockOptions(CustomItemBedrockOptions.builder().icon(this.icon()).allowOffhand(this.allowOffhand()).displayHandheld(this.displayHandheld()).creativeCategory(this.creativeCategory().isEmpty() ? CreativeCategory.NONE : CreativeCategory.values()[this.creativeCategory().getAsInt()]).creativeGroup(this.creativeGroup()).tags(this.tags().stream().map(Identifier::of).collect(Collectors.toSet())));
        CustomItemOptions options = this.customItemOptions();
        if (options.customModelData().isPresent()) {
            definition.predicate(ItemRangeDispatchPredicate.legacyCustomModelData(options.customModelData().getAsInt()));
        }
        if (options.damagePredicate().isPresent()) {
            definition.predicate(ItemRangeDispatchPredicate.normalizedDamage(options.damagePredicate().getAsInt()));
        }
        if (options.unbreakable() != TriState.NOT_SET) {
            if (options.unbreakable() == TriState.TRUE) {
                definition.predicate(ItemConditionPredicate.UNBREAKABLE);
            } else {
                definition.predicate((MinecraftPredicate<? super ItemPredicateContext>)ItemConditionPredicate.UNBREAKABLE.negate());
            }
        }
        if (this.renderOffsets() != null) {
            definition.renderOffsets(this.renderOffsets());
        }
        if (this.textureSize() != 16) {
            definition.textureSize(this.textureSize());
        }
        definition.isOldConvertedItem();
        return definition;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeyserCustomItemData)) {
            return false;
        }
        GeyserCustomItemData other = (GeyserCustomItemData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.allowOffhand != other.allowOffhand) {
            return false;
        }
        if (this.displayHandheld != other.displayHandheld) {
            return false;
        }
        if (this.textureSize != other.textureSize) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        CustomItemOptions this$customItemOptions = this.customItemOptions;
        CustomItemOptions other$customItemOptions = other.customItemOptions;
        if (this$customItemOptions == null ? other$customItemOptions != null : !this$customItemOptions.equals(other$customItemOptions)) {
            return false;
        }
        String this$displayName = this.displayName;
        String other$displayName = other.displayName;
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$icon = this.icon;
        String other$icon = other.icon;
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        OptionalInt this$creativeCategory = this.creativeCategory;
        OptionalInt other$creativeCategory = other.creativeCategory;
        if (this$creativeCategory == null ? other$creativeCategory != null : !((Object)this$creativeCategory).equals(other$creativeCategory)) {
            return false;
        }
        String this$creativeGroup = this.creativeGroup;
        String other$creativeGroup = other.creativeGroup;
        if (this$creativeGroup == null ? other$creativeGroup != null : !this$creativeGroup.equals(other$creativeGroup)) {
            return false;
        }
        CustomRenderOffsets this$renderOffsets = this.renderOffsets;
        CustomRenderOffsets other$renderOffsets = other.renderOffsets;
        if (this$renderOffsets == null ? other$renderOffsets != null : !((Object)this$renderOffsets).equals(other$renderOffsets)) {
            return false;
        }
        Set<String> this$tags = this.tags;
        Set<String> other$tags = other.tags;
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeyserCustomItemData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.allowOffhand ? 79 : 97);
        result = result * 59 + (this.displayHandheld ? 79 : 97);
        result = result * 59 + this.textureSize;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        CustomItemOptions $customItemOptions = this.customItemOptions;
        result = result * 59 + ($customItemOptions == null ? 43 : $customItemOptions.hashCode());
        String $displayName = this.displayName;
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $icon = this.icon;
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        OptionalInt $creativeCategory = this.creativeCategory;
        result = result * 59 + ($creativeCategory == null ? 43 : ((Object)$creativeCategory).hashCode());
        String $creativeGroup = this.creativeGroup;
        result = result * 59 + ($creativeGroup == null ? 43 : $creativeGroup.hashCode());
        CustomRenderOffsets $renderOffsets = this.renderOffsets;
        result = result * 59 + ($renderOffsets == null ? 43 : ((Object)$renderOffsets).hashCode());
        Set<String> $tags = this.tags;
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GeyserCustomItemData(name=" + this.name + ", customItemOptions=" + String.valueOf(this.customItemOptions) + ", displayName=" + this.displayName + ", icon=" + this.icon + ", allowOffhand=" + this.allowOffhand + ", displayHandheld=" + this.displayHandheld + ", creativeCategory=" + String.valueOf(this.creativeCategory) + ", creativeGroup=" + this.creativeGroup + ", textureSize=" + this.textureSize + ", renderOffsets=" + String.valueOf(this.renderOffsets) + ", tags=" + String.valueOf(this.tags) + ")";
    }

    public static class Builder
    implements CustomItemData.Builder {
        protected String name = null;
        protected CustomItemOptions customItemOptions = null;
        protected String displayName = null;
        protected String icon = null;
        protected boolean allowOffhand = true;
        protected boolean displayHandheld = false;
        protected OptionalInt creativeCategory = OptionalInt.empty();
        protected String creativeGroup = null;
        protected int textureSize = 16;
        protected CustomRenderOffsets renderOffsets = null;
        protected Set<String> tags = new HashSet<String>();

        @Override
        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder customItemOptions(@NonNull CustomItemOptions customItemOptions) {
            this.customItemOptions = customItemOptions;
            return this;
        }

        @Override
        public Builder displayName(@NonNull String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public Builder icon(@NonNull String icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public Builder allowOffhand(boolean allowOffhand) {
            this.allowOffhand = allowOffhand;
            return this;
        }

        @Override
        public Builder displayHandheld(boolean displayHandheld) {
            this.displayHandheld = displayHandheld;
            return this;
        }

        @Override
        public Builder creativeCategory(int creativeCategory) {
            this.creativeCategory = OptionalInt.of(creativeCategory);
            return this;
        }

        @Override
        public Builder creativeGroup(@Nullable String creativeGroup) {
            this.creativeGroup = creativeGroup;
            return this;
        }

        @Override
        public Builder textureSize(int textureSize) {
            this.textureSize = textureSize;
            return this;
        }

        @Override
        public Builder renderOffsets(CustomRenderOffsets renderOffsets) {
            this.renderOffsets = renderOffsets;
            return this;
        }

        @Override
        public Builder tags(@Nullable Set<String> tags) {
            this.tags = Objects.requireNonNullElseGet(tags, Set::of);
            return this;
        }

        @Override
        public CustomItemData build() {
            if (this.name == null || this.customItemOptions == null) {
                throw new IllegalArgumentException("Name and custom item options must be set");
            }
            if (this.displayName == null) {
                this.displayName = this.name;
            }
            if (this.icon == null) {
                this.icon = this.name;
            }
            if (this.textureSize != 16) {
                GeyserImpl.getInstance().getLogger().warning("The custom item %s is using a non-standard texture size! ".formatted(this.name) + "This feature is deprecated and will be removed in a future version! Please migrate to attachables for texture resizing.");
            }
            if (this.renderOffsets != null) {
                GeyserImpl.getInstance().getLogger().warning("The custom item %s is using render offsets! ".formatted(this.name) + "These are deprecated and will be removed in a future version! Please migrate to attachables.");
            }
            return new GeyserCustomItemData(this.name, this.customItemOptions, this.displayName, this.icon, this.allowOffhand, this.displayHandheld, this.creativeCategory, this.creativeGroup, this.textureSize, this.renderOffsets, this.tags);
        }
    }
}

