/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.extension;

import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.extension.ExtensionDescription;
import org.geysermc.geyser.api.extension.exception.InvalidDescriptionException;
import org.geysermc.geyser.text.GeyserLocale;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;

public record GeyserExtensionDescription(@NonNull String id, @NonNull String name, @NonNull String main, int humanApiVersion, int majorApiVersion, int minorApiVersion, @NonNull String version, @NonNull List<String> authors, @NonNull Map<String, Dependency> dependencies) implements ExtensionDescription
{
    private static final Yaml YAML = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(Source.class.getClassLoader(), new LoaderOptions()));
    public static final Pattern ID_PATTERN = Pattern.compile("[a-z][a-z0-9-_]{0,63}");
    public static final Pattern NAME_PATTERN = Pattern.compile("^[A-Za-z_.-]+$");
    public static final Pattern API_VERSION_PATTERN = Pattern.compile("^\\d+\\.\\d+\\.\\d+$");

    public static @NonNull GeyserExtensionDescription fromYaml(Reader reader) throws InvalidDescriptionException {
        Source source;
        try {
            source = (Source)YAML.loadAs(reader, Source.class);
        }
        catch (Exception e) {
            throw new InvalidDescriptionException(e);
        }
        String id = GeyserExtensionDescription.require(source::getId, "id");
        if (!ID_PATTERN.matcher(id).matches()) {
            throw new InvalidDescriptionException("Invalid extension id, must match: " + ID_PATTERN.pattern());
        }
        String name = GeyserExtensionDescription.require(source::getName, "name");
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new InvalidDescriptionException("Invalid extension name, must match: " + NAME_PATTERN.pattern());
        }
        String version = String.valueOf(source.version);
        String main = GeyserExtensionDescription.require(source::getMain, "main");
        String apiVersion = GeyserExtensionDescription.require(source::getApi, "api");
        if (!API_VERSION_PATTERN.matcher(apiVersion).matches()) {
            throw new InvalidDescriptionException(GeyserLocale.getLocaleStringLog("geyser.extensions.load.failed_api_format", name, apiVersion));
        }
        String[] api = apiVersion.split("\\.");
        int humanApi = Integer.parseUnsignedInt(api[0]);
        int majorApi = Integer.parseUnsignedInt(api[1]);
        int minorApi = Integer.parseUnsignedInt(api[2]);
        ArrayList<String> authors = new ArrayList<String>();
        if (source.author != null) {
            authors.add(source.author);
        }
        if (source.authors != null) {
            authors.addAll(source.authors);
        }
        LinkedHashMap<String, Dependency> dependencies = new LinkedHashMap<String, Dependency>();
        if (source.dependencies != null) {
            dependencies.putAll(source.dependencies);
        }
        return new GeyserExtensionDescription(id, name, main, humanApi, majorApi, minorApi, version, authors, dependencies);
    }

    private static @NonNull String require(Supplier<String> supplier, String name) throws InvalidDescriptionException {
        String value = supplier.get();
        if (value == null) {
            throw new InvalidDescriptionException("Extension description is missing string property '" + name + "'");
        }
        return value;
    }

    public static class Source {
        String id;
        String name;
        String main;
        String api;
        String version;
        String author;
        List<String> authors;
        Map<String, Dependency> dependencies;

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getMain() {
            return this.main;
        }

        @Generated
        public String getApi() {
            return this.api;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getAuthor() {
            return this.author;
        }

        @Generated
        public List<String> getAuthors() {
            return this.authors;
        }

        @Generated
        public Map<String, Dependency> getDependencies() {
            return this.dependencies;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setMain(String main) {
            this.main = main;
        }

        @Generated
        public void setApi(String api) {
            this.api = api;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public void setAuthor(String author) {
            this.author = author;
        }

        @Generated
        public void setAuthors(List<String> authors) {
            this.authors = authors;
        }

        @Generated
        public void setDependencies(Map<String, Dependency> dependencies) {
            this.dependencies = dependencies;
        }
    }

    public static enum LoadOrder {
        BEFORE,
        AFTER;

    }

    public static class Dependency {
        boolean required = true;
        LoadOrder load = LoadOrder.BEFORE;

        @Generated
        public boolean isRequired() {
            return this.required;
        }

        @Generated
        public LoadOrder getLoad() {
            return this.load;
        }

        @Generated
        public void setRequired(boolean required) {
            this.required = required;
        }

        @Generated
        public void setLoad(LoadOrder load) {
            this.load = load;
        }
    }
}

