/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.erosion;

import io.netty.channel.Channel;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.erosion.netty.NettyPacketSender;
import org.geysermc.erosion.packet.ErosionPacketHandler;
import org.geysermc.erosion.packet.geyserbound.GeyserboundHandshakePacket;
import org.geysermc.geyser.erosion.AbstractGeyserboundPacketHandler;
import org.geysermc.geyser.erosion.GeyserErosionPacketSender;
import org.geysermc.geyser.erosion.GeyserboundPacketHandlerImpl;
import org.geysermc.geyser.session.GeyserSession;

public final class GeyserboundHandshakePacketHandler
extends AbstractGeyserboundPacketHandler {
    public GeyserboundHandshakePacketHandler(GeyserSession session) {
        super(session);
    }

    public void handleHandshake(GeyserboundHandshakePacket packet) {
        boolean useTcp = packet.getTransportType().getSocketAddress() == null;
        GeyserboundPacketHandlerImpl handler = new GeyserboundPacketHandlerImpl(this.session, useTcp ? new GeyserErosionPacketSender(this.session) : new NettyPacketSender());
        if (!useTcp) {
            if (this.session.getGeyser().getErosionUnixListener() == null) {
                this.session.disconnect("Erosion configurations using Unix socket handling are not supported on this hardware!");
                return;
            }
            this.session.getGeyser().getErosionUnixListener().createClient(handler, packet.getTransportType().getSocketAddress());
        } else {
            handler.onConnect();
        }
        this.session.setErosionHandler(handler);
        this.session.ensureInEventLoop(() -> this.session.getChunkCache().clear());
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public @Nullable GeyserboundPacketHandlerImpl getAsActive() {
        return null;
    }

    public @Nullable ErosionPacketHandler setChannel(Channel channel) {
        return null;
    }
}

