/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.vehicle;

import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.type.living.animal.nautilus.AbstractNautilusEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.entity.vehicle.VehicleComponent;
import org.geysermc.geyser.util.MathUtils;

public class NautilusVehicleComponent
extends VehicleComponent<AbstractNautilusEntity> {
    private int dashCooldown;

    public NautilusVehicleComponent(AbstractNautilusEntity vehicle, float stepHeight, float defSpeed) {
        super(vehicle, stepHeight);
        this.moveSpeed = defSpeed;
    }

    @Override
    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    public void tickVehicle() {
        ((AbstractNautilusEntity)this.vehicle).setFlag(EntityFlag.HAS_DASH_COOLDOWN, this.dashCooldown > 0);
        ((AbstractNautilusEntity)this.vehicle).updateBedrockMetadata();
        super.tickVehicle();
        if (this.dashCooldown > 0) {
            --this.dashCooldown;
        }
    }

    @Override
    protected Vector3f getInputVector(VehicleComponent.VehicleContext ctx, float speed, Vector3f input) {
        Vector3f inputVelocity = super.getInputVector(ctx, speed, input);
        SessionPlayerEntity player = ((AbstractNautilusEntity)this.vehicle).getSession().getPlayerEntity();
        float jumpStrength = player.getVehicleJumpStrength();
        player.setVehicleJumpStrength(0);
        if (jumpStrength > 0.0f) {
            Vector3f viewVector = MathUtils.calculateViewVector(player.getPitch(), player.getYaw());
            float movementMultiplier = this.getVelocityMultiplier(ctx);
            float strength = (float)((double)movementMultiplier + this.movementEfficiency * (double)(1.0f - movementMultiplier));
            jumpStrength = jumpStrength >= 90.0f ? 1.0f : 0.4f + 0.4f * jumpStrength / 90.0f;
            inputVelocity = inputVelocity.add(viewVector.mul((this.isInWater() ? 1.2f : 0.5f) * jumpStrength * this.getMoveSpeed() * strength));
            this.setDashCooldown(40);
        }
        return inputVelocity;
    }

    @Override
    public void onDismount() {
        ((AbstractNautilusEntity)this.vehicle).setFlag(EntityFlag.HAS_DASH_COOLDOWN, false);
        ((AbstractNautilusEntity)this.vehicle).updateBedrockMetadata();
        super.onDismount();
    }

    @Override
    protected void updateRotation() {
        float yaw = ((AbstractNautilusEntity)this.vehicle).getYaw() + MathUtils.wrapDegrees(this.getRiddenRotation().getX() - ((AbstractNautilusEntity)this.vehicle).getYaw()) * 0.5f;
        ((AbstractNautilusEntity)this.vehicle).setYaw(yaw);
        ((AbstractNautilusEntity)this.vehicle).setHeadYaw(yaw);
    }

    @Override
    protected void waterMovement(VehicleComponent.VehicleContext ctx, double height) {
        this.travel(ctx, ((AbstractNautilusEntity)this.vehicle).getVehicleSpeed());
        ((AbstractNautilusEntity)this.vehicle).setMotion(((AbstractNautilusEntity)this.vehicle).getMotion().mul(0.9f));
    }

    public void setDashCooldown(int cooldown) {
        this.dashCooldown = this.dashCooldown == 0 ? cooldown : this.dashCooldown;
        ((AbstractNautilusEntity)this.vehicle).setFlag(EntityFlag.HAS_DASH_COOLDOWN, this.dashCooldown > 0);
        ((AbstractNautilusEntity)this.vehicle).updateBedrockMetadata();
    }
}

