/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.vehicle;

import lombok.Generated;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.type.living.animal.horse.AbstractHorseEntity;
import org.geysermc.geyser.entity.type.living.animal.horse.SkeletonHorseEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.entity.vehicle.VehicleComponent;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;

public class HorseVehicleComponent
extends VehicleComponent<AbstractHorseEntity> {
    private float horseJumpStrength = 0.7f;
    private int effectJumpBoost;
    private boolean allowStandSliding;

    public HorseVehicleComponent(AbstractHorseEntity vehicle) {
        super(vehicle, 1.5f);
    }

    @Override
    public void tickVehicle() {
        if (!((AbstractHorseEntity)this.vehicle).getFlag(EntityFlag.STANDING)) {
            this.allowStandSliding = false;
        }
        super.tickVehicle();
    }

    @Override
    protected Vector3f getInputVector(VehicleComponent.VehicleContext ctx, float speed, Vector3f input) {
        SessionPlayerEntity player = ((AbstractHorseEntity)this.vehicle).getSession().getPlayerEntity();
        float jumpLeapStrength = player.getVehicleJumpStrength();
        if (((AbstractHorseEntity)this.vehicle).isOnGround() && jumpLeapStrength == 0.0f && ((AbstractHorseEntity)this.vehicle).getFlag(EntityFlag.STANDING) && !this.allowStandSliding) {
            return Vector3f.ZERO;
        }
        player.setVehicleJumpStrength(0);
        Vector3f inputVelocity = super.getInputVector(ctx, speed, input);
        if (((AbstractHorseEntity)this.vehicle).isOnGround() && jumpLeapStrength > 0.0f) {
            jumpLeapStrength = jumpLeapStrength >= 90.0f ? 1.0f : 0.4f + 0.4f * jumpLeapStrength / 90.0f;
            float jumpStrength = this.horseJumpStrength * this.getJumpVelocityMultiplier(ctx) + (float)this.effectJumpBoost * 0.1f;
            inputVelocity = Vector3f.from((float)inputVelocity.getX(), (float)jumpStrength, (float)inputVelocity.getZ());
            if ((double)input.getZ() > 0.0) {
                inputVelocity = inputVelocity.add((double)(-0.4f * TrigMath.sin((double)(((AbstractHorseEntity)this.vehicle).getYaw() * ((float)Math.PI / 180))) * jumpLeapStrength), 0.0, (double)(0.4f * TrigMath.cos((double)(((AbstractHorseEntity)this.vehicle).getYaw() * ((float)Math.PI / 180))) * jumpLeapStrength));
            }
        }
        return inputVelocity;
    }

    @Override
    protected float getWaterSlowDown() {
        return this.vehicle instanceof SkeletonHorseEntity ? 0.96f : super.getWaterSlowDown();
    }

    @Override
    public void setEffect(Effect effect, int effectAmplifier) {
        if (effect == Effect.JUMP_BOOST) {
            this.effectJumpBoost = effectAmplifier + 1;
        } else {
            super.setEffect(effect, effectAmplifier);
        }
    }

    @Override
    public void removeEffect(Effect effect) {
        if (effect == Effect.JUMP_BOOST) {
            this.effectJumpBoost = 0;
        } else {
            super.removeEffect(effect);
        }
    }

    @Override
    public boolean canFloatWhileRidden() {
        return true;
    }

    @Override
    public float getEyeHeight() {
        return ((AbstractHorseEntity)this.vehicle).isBaby() ? 0.76f : 1.52f;
    }

    @Generated
    public void setHorseJumpStrength(float horseJumpStrength) {
        this.horseJumpStrength = horseJumpStrength;
    }

    @Generated
    public void setAllowStandSliding(boolean allowStandSliding) {
        this.allowStandSliding = allowStandSliding;
    }
}

