/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.entity.properties.type.EnumProperty;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.impl.IdentifierImpl;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.ArmadilloState;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ObjectEntityMetadata;

public class ArmadilloEntity
extends AnimalEntity {
    public static final EnumProperty<State> STATE_PROPERTY = new EnumProperty<State>(IdentifierImpl.of("armadillo_state"), State.class, State.UNROLLED);
    private ArmadilloState armadilloState = ArmadilloState.IDLE;

    public ArmadilloEntity(EntitySpawnContext context) {
        super(context);
    }

    public void setArmadilloState(ObjectEntityMetadata<ArmadilloState> entityMetadata) {
        this.armadilloState = (ArmadilloState)entityMetadata.getValue();
        switch (this.armadilloState) {
            case IDLE: {
                STATE_PROPERTY.apply(this.propertyManager, State.UNROLLED);
                break;
            }
            case ROLLING: {
                STATE_PROPERTY.apply(this.propertyManager, State.ROLLED_UP);
                break;
            }
            case SCARED: {
                STATE_PROPERTY.apply(this.propertyManager, State.ROLLED_UP_RELAXING);
                break;
            }
            case UNROLLING: {
                STATE_PROPERTY.apply(this.propertyManager, State.ROLLED_UP_UNROLLING);
            }
        }
        this.updateBedrockEntityProperties();
    }

    public void onPeeking() {
        if (this.armadilloState == ArmadilloState.SCARED) {
            STATE_PROPERTY.apply(this.propertyManager, State.ROLLED_UP_PEEKING);
            this.updateBedrockEntityProperties();
            this.session.scheduleInEventLoop(() -> {
                if (this.armadilloState == ArmadilloState.SCARED) {
                    STATE_PROPERTY.apply(this.propertyManager, State.ROLLED_UP_RELAXING);
                    this.updateBedrockEntityProperties();
                }
            }, 250L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.ARMADILLO_FOOD;
    }

    public static enum State {
        UNROLLED,
        ROLLED_UP,
        ROLLED_UP_PEEKING,
        ROLLED_UP_RELAXING,
        ROLLED_UP_UNROLLING;

    }
}

