/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.GolemEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class SnowGolemEntity
extends GolemEntity {
    public SnowGolemEntity(EntitySpawnContext context) {
        super(context);
    }

    public void setSnowGolemFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.SHEARED, (xd & 0x10) != 16);
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (itemInHand.is(Items.SHEARS) && this.isAlive() && !this.getFlag(EntityFlag.SHEARED)) {
            return InteractiveTag.SHEAR;
        }
        return InteractiveTag.NONE;
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (itemInHand.is(Items.SHEARS) && this.isAlive() && !this.getFlag(EntityFlag.SHEARED)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

