/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.MobEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class AllayEntity
extends MobEntity {
    private boolean canDuplicate;

    public AllayEntity(EntitySpawnContext context) {
        super(context);
    }

    public void setDancing(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.DANCING, entityMetadata.getPrimitiveValue());
    }

    public void setCanDuplicate(BooleanEntityMetadata entityMetadata) {
        this.canDuplicate = entityMetadata.getPrimitiveValue();
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.canDuplicate && this.getFlag(EntityFlag.DANCING) && this.isDuplicationItem(itemInHand)) {
            return InteractiveTag.GIVE_ITEM_TO_ALLAY;
        }
        if (this.getMainHandItem().isEmpty() && !itemInHand.isEmpty()) {
            return InteractiveTag.GIVE_ITEM_TO_ALLAY;
        }
        if (!this.getMainHandItem().isEmpty() && hand == Hand.MAIN_HAND && itemInHand.isEmpty()) {
            return InteractiveTag.GIVE_ITEM_TO_ALLAY;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.canDuplicate && this.getFlag(EntityFlag.DANCING) && this.isDuplicationItem(itemInHand)) {
            return InteractionResult.SUCCESS;
        }
        if (this.getMainHandItem().isEmpty() && !itemInHand.isEmpty()) {
            return InteractionResult.SUCCESS;
        }
        if (!this.getMainHandItem().isEmpty() && hand == Hand.MAIN_HAND && itemInHand.isEmpty()) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }

    private boolean isDuplicationItem(GeyserItemStack itemStack) {
        return itemStack.is(this.session, ItemTag.DUPLICATES_ALLAYS);
    }
}

