/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.ThrowableEntity;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class ThrowableItemEntity
extends ThrowableEntity {
    private int age;
    private boolean invisible;

    public ThrowableItemEntity(EntitySpawnContext context) {
        super(context);
        this.setFlag(EntityFlag.INVISIBLE, true);
        this.invisible = false;
        this.age = 0;
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.SCALE, Float.valueOf(0.5f));
    }

    private void checkVisibility() {
        ++this.age;
        if (this.session.isTickingFrozen()) {
            Vector3f playerPos = this.session.getPlayerEntity().getPosition().down(EntityDefinitions.PLAYER.offset());
            this.setInvisible((double)playerPos.distanceSquared(this.position.add(0.0f, this.definition.offset(), 0.0f)) < 12.25);
        } else {
            this.setInvisible(this.age < 2);
        }
        if (this.invisible != this.getFlag(EntityFlag.INVISIBLE)) {
            this.setFlag(EntityFlag.INVISIBLE, this.invisible);
            this.updateBedrockMetadata();
        }
    }

    @Override
    public void drawTick() {
        this.checkVisibility();
        super.drawTick();
    }

    @Override
    protected void setInvisible(boolean value) {
        this.invisible = value;
    }

    public void setItem(EntityMetadata<ItemStack, ?> entityMetadata) {
    }
}

