/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.Optional;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.DisplayBaseEntity;
import org.geysermc.geyser.entity.type.living.ArmorStandEntity;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.jetbrains.annotations.Nullable;

public class TextDisplayEntity
extends DisplayBaseEntity {
    private static final float LINE_HEIGHT_OFFSET = 0.1414f;
    @Nullable
    private ArmorStandEntity secondEntity = null;
    private boolean isInvisible = false;
    private int lineCount;

    public TextDisplayEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.HITBOX, NbtMap.EMPTY);
        this.dirtyMetadata.put(EntityDataTypes.SCALE, Float.valueOf(0.0f));
        this.dirtyMetadata.put(EntityDataTypes.NAMETAG_ALWAYS_SHOW, (byte)1);
    }

    @Override
    protected void setInvisible(boolean value) {
        this.isInvisible = value;
        this.updateNameTag();
    }

    @Override
    public void setCustomNameVisible(BooleanEntityMetadata entityMetadata) {
        super.setCustomNameVisible(entityMetadata);
        this.updateNameTag();
    }

    @Override
    public void setCustomName(EntityMetadata<Optional<Component>, ?> entityMetadata) {
        super.setCustomName(entityMetadata);
        this.updateNameTag();
    }

    @Override
    public void setNametagAlwaysShow(boolean value) {
    }

    @Override
    protected void setNameEntityData(String nametag) {
    }

    @Override
    public void despawnEntity() {
        if (this.secondEntity != null) {
            this.secondEntity.despawnEntity();
        }
        super.despawnEntity();
    }

    @Override
    public void moveRelativeRaw(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        if (this.secondEntity != null) {
            this.secondEntity.moveRelativeRaw(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
        }
        super.moveRelativeRaw(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
    }

    @Override
    public void moveAbsoluteRaw(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        if (this.secondEntity != null) {
            this.secondEntity.moveAbsoluteRaw(position.down(0.1414f), yaw, pitch, headYaw, isOnGround, teleported);
        }
        super.moveAbsoluteRaw(position.up(this.calculateLineOffset()), yaw, pitch, headYaw, isOnGround, teleported);
    }

    public void setText(EntityMetadata<Component, ?> entityMetadata) {
        this.dirtyMetadata.put(EntityDataTypes.NAME, MessageTranslator.convertMessage((Component)entityMetadata.getValue(), this.session.locale()));
        int oldLineCount = this.lineCount;
        this.lineCount = this.calculateLineCount((Component)entityMetadata.getValue());
        if (this.lineCount != oldLineCount) {
            Vector3f positionWithoutOffset = this.position.down(TextDisplayEntity.calculateLineOffset(oldLineCount));
            this.moveAbsoluteRaw(positionWithoutOffset, this.yaw, this.pitch, this.headYaw, this.onGround, false);
        }
    }

    private int calculateLineCount(@Nullable Component text) {
        if (text == null) {
            return 0;
        }
        return PlainTextComponentSerializer.plainText().serialize(text).split("\n").length;
    }

    @Override
    public void updateBedrockMetadata() {
        if (this.secondEntity != null) {
            if (!this.secondEntity.valid) {
                this.secondEntity.spawnEntity();
            } else {
                this.secondEntity.updateBedrockMetadata();
            }
        }
        super.updateBedrockMetadata();
    }

    public void updateNameTag() {
        if (this.nametag.isBlank() || this.isInvisible || !this.customNameVisible) {
            if (this.secondEntity != null) {
                this.secondEntity.despawnEntity();
                this.secondEntity = null;
            }
            return;
        }
        if (this.secondEntity == null) {
            this.secondEntity = new ArmorStandEntity(EntitySpawnContext.inherited(this.session, EntityDefinitions.ARMOR_STAND, this, this.position.down(this.calculateLineOffset()).down(0.1414f)));
        }
        this.secondEntity.getDirtyMetadata().put(EntityDataTypes.NAME, this.nametag);
        this.secondEntity.getDirtyMetadata().put(EntityDataTypes.NAMETAG_ALWAYS_SHOW, (byte)1);
        this.secondEntity.setScale(0.0f);
        this.secondEntity.getDirtyMetadata().put(EntityDataTypes.WIDTH, Float.valueOf(0.0f));
        this.secondEntity.getDirtyMetadata().put(EntityDataTypes.HEIGHT, Float.valueOf(0.0f));
        this.secondEntity.getDirtyMetadata().put(EntityDataTypes.HITBOX, NbtMap.EMPTY);
    }

    public float calculateLineOffset() {
        return TextDisplayEntity.calculateLineOffset(this.lineCount);
    }

    public static float calculateLineOffset(int lineCount) {
        if (lineCount == 0) {
            return 0.0f;
        }
        return -0.6f + 0.1414f * (float)lineCount;
    }

    @Nullable
    @Generated
    public ArmorStandEntity getSecondEntity() {
        return this.secondEntity;
    }

    @Generated
    public boolean isInvisible() {
        return this.isInvisible;
    }

    @Generated
    public int getLineCount() {
        return this.lineCount;
    }
}

