/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.AnimatePacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.ArmorStandEntity;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundSwingPacket;

public class InteractionEntity
extends Entity {
    private boolean response = false;
    private ArmorStandEntity secondEntity = null;
    private boolean isInvisible = false;

    public InteractionEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.setFlag(EntityFlag.INVISIBLE, true);
    }

    @Override
    protected void setInvisible(boolean value) {
        this.isInvisible = value;
        this.updateNameTag();
    }

    @Override
    public void setCustomNameVisible(BooleanEntityMetadata entityMetadata) {
        super.setCustomNameVisible(entityMetadata);
        this.updateNameTag();
    }

    @Override
    public void setCustomName(EntityMetadata<Optional<Component>, ?> entityMetadata) {
        super.setCustomName(entityMetadata);
        this.updateNameTag();
    }

    @Override
    public InteractionResult interact(Hand hand) {
        if (this.response) {
            AnimatePacket animatePacket = new AnimatePacket();
            animatePacket.setRuntimeEntityId(this.session.getPlayerEntity().geyserId());
            animatePacket.setAction(AnimatePacket.Action.SWING_ARM);
            this.session.sendUpstreamPacket((BedrockPacket)animatePacket);
            this.session.sendDownstreamGamePacket((Packet)new ServerboundSwingPacket(hand));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void despawnEntity() {
        if (this.secondEntity != null) {
            this.secondEntity.despawnEntity();
        }
        super.despawnEntity();
    }

    @Override
    public void moveRelativeRaw(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        this.moveAbsoluteRaw(this.position.add(relX, relY, relZ), yaw, pitch, headYaw, isOnGround, false);
    }

    @Override
    public void moveAbsoluteRaw(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        if (this.secondEntity != null) {
            this.secondEntity.moveAbsoluteRaw(position.up(this.getBoundingBoxHeight()), yaw, pitch, headYaw, isOnGround, teleported);
        }
        super.moveAbsoluteRaw(position, yaw, pitch, headYaw, isOnGround, teleported);
    }

    public void setWidth(FloatEntityMetadata width) {
        this.setBoundingBoxWidth(width.getPrimitiveValue());
    }

    public void setHeight(FloatEntityMetadata height) {
        this.setBoundingBoxHeight(Math.min(height.getPrimitiveValue(), 64.0f));
        if (this.secondEntity != null) {
            this.secondEntity.moveAbsoluteRaw(this.position.up(this.getBoundingBoxHeight()), this.yaw, this.pitch, this.headYaw, this.onGround, true);
        }
    }

    public void setResponse(BooleanEntityMetadata response) {
        this.response = response.getPrimitiveValue();
    }

    @Override
    public void updateBedrockMetadata() {
        if (this.secondEntity != null) {
            if (!this.secondEntity.valid) {
                this.secondEntity.spawnEntity();
            } else {
                this.secondEntity.updateBedrockMetadata();
            }
        }
        super.updateBedrockMetadata();
    }

    public void updateNameTag() {
        if (this.nametag.isBlank() || this.isInvisible) {
            if (this.secondEntity != null) {
                this.secondEntity.despawnEntity();
                this.secondEntity = null;
            }
            return;
        }
        if (this.secondEntity == null) {
            this.secondEntity = new ArmorStandEntity(EntitySpawnContext.inherited(this.session, EntityDefinitions.ARMOR_STAND, this, this.position.up(this.getBoundingBoxHeight())));
        }
        this.secondEntity.getDirtyMetadata().put(EntityDataTypes.NAME, this.nametag);
        this.secondEntity.getDirtyMetadata().put(EntityDataTypes.NAMETAG_ALWAYS_SHOW, this.customNameVisible ? (byte)1 : 0);
        this.secondEntity.setScale(0.0f);
        this.secondEntity.getDirtyMetadata().put(EntityDataTypes.WIDTH, Float.valueOf(0.0f));
        this.secondEntity.getDirtyMetadata().put(EntityDataTypes.HEIGHT, Float.valueOf(0.0f));
        this.secondEntity.getDirtyMetadata().put(EntityDataTypes.HITBOX, NbtMap.EMPTY);
    }
}

