/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.api.item.custom.v2.component.java;

import java.util.function.Predicate;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.item.custom.v2.component.ItemDataComponent;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaAttackRange;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaConsumable;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaEquippable;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaFoodProperties;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaKineticWeapon;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaPiercingWeapon;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaRepairable;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaSwingAnimation;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaTool;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaUseCooldown;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaUseEffects;
import org.geysermc.geyser.api.util.Identifier;

public interface JavaItemDataComponents {
    public static final ItemDataComponent<JavaConsumable> CONSUMABLE = JavaItemDataComponents.create("consumable");
    public static final ItemDataComponent<JavaEquippable> EQUIPPABLE = JavaItemDataComponents.create("equippable");
    public static final ItemDataComponent<JavaFoodProperties> FOOD = JavaItemDataComponents.create("food");
    public static final ItemDataComponent<Integer> MAX_DAMAGE = JavaItemDataComponents.create("max_damage", i -> i >= 0);
    public static final ItemDataComponent<Integer> MAX_STACK_SIZE = JavaItemDataComponents.create("max_stack_size", i -> i >= 1 && i <= 99);
    public static final ItemDataComponent<JavaUseCooldown> USE_COOLDOWN = JavaItemDataComponents.create("use_cooldown");
    public static final ItemDataComponent<Integer> ENCHANTABLE = JavaItemDataComponents.create("enchantable", i -> i >= 0);
    public static final ItemDataComponent<JavaTool> TOOL = JavaItemDataComponents.create("tool");
    public static final ItemDataComponent<JavaRepairable> REPAIRABLE = JavaItemDataComponents.create("repairable");
    public static final ItemDataComponent<Boolean> ENCHANTMENT_GLINT_OVERRIDE = JavaItemDataComponents.create("enchantment_glint_override");
    public static final ItemDataComponent<JavaAttackRange> ATTACK_RANGE = JavaItemDataComponents.create("attack_range");
    public static final ItemDataComponent<JavaKineticWeapon> KINETIC_WEAPON = JavaItemDataComponents.create("kinetic_weapon");
    public static final ItemDataComponent<JavaPiercingWeapon> PIERCING_WEAPON = JavaItemDataComponents.create("piercing_weapon");
    public static final ItemDataComponent<JavaSwingAnimation> SWING_ANIMATION = JavaItemDataComponents.create("swing_animation");
    public static final ItemDataComponent<JavaUseEffects> USE_EFFECTS = JavaItemDataComponents.create("use_effects");

    private static <T> ItemDataComponent<T> create(String id) {
        return JavaItemDataComponents.create(id, t -> true);
    }

    private static <T> ItemDataComponent<T> create(String id, Predicate<T> consumer) {
        return (ItemDataComponent)GeyserApi.api().provider(ItemDataComponent.class, Identifier.of(id), consumer, true);
    }
}

