/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.configuration.GeyserConfig;
import org.geysermc.geyser.text.GeyserLocale;

public class FloodgateKeyLoader {
    public static Path getKeyPath(GeyserConfig config, Path floodgateDataFolder, Path geyserDataFolder, GeyserLogger logger) {
        Path floodgateKey;
        if (floodgateDataFolder != null) {
            Path autoKey = floodgateDataFolder.resolve("key.pem");
            if (Files.exists(autoKey, new LinkOption[0])) {
                logger.debug(GeyserLocale.getLocaleStringLog("geyser.bootstrap.floodgate.auto_loaded"));
                return autoKey;
            }
            logger.error(GeyserLocale.getLocaleStringLog("geyser.bootstrap.floodgate.missing_key"));
        }
        if (!Files.exists(floodgateKey = geyserDataFolder.resolve(config.advanced().floodgateKeyFile()), new LinkOption[0])) {
            logger.error(GeyserLocale.getLocaleStringLog("geyser.bootstrap.floodgate.not_installed"));
        }
        return floodgateKey;
    }
}

