/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class HttpClient {
    private static final String USER_AGENT = "GeyserMC/Floodgate";
    private final Gson gson = new Gson();
    @Inject
    @Named(value="commonPool")
    private ExecutorService executorService;

    public CompletableFuture<DefaultHttpResponse> asyncGet(String urlString) {
        return CompletableFuture.supplyAsync(() -> this.get(urlString), this.executorService);
    }

    public <T> CompletableFuture<HttpResponse<T>> asyncGet(String urlString, Class<T> response) {
        return CompletableFuture.supplyAsync(() -> this.get(urlString, response), this.executorService);
    }

    public DefaultHttpResponse get(String urlString) {
        return this.readDefaultResponse(this.request(urlString));
    }

    public <T> HttpResponse<T> get(String urlString, Class<T> clazz) {
        return this.readResponse(this.request(urlString), clazz);
    }

    public <T> HttpResponse<T> getSilent(String urlString, Class<T> clazz) {
        return this.readResponseSilent(this.request(urlString), clazz);
    }

    private HttpURLConnection request(String urlString) {
        HttpURLConnection connection;
        try {
            URL url = new URL(urlString.replace(" ", "%20"));
            connection = (HttpURLConnection)url.openConnection();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create connection", exception);
        }
        try {
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(5000);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create request", exception);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> @NonNull HttpResponse<T> readResponse(HttpURLConnection connection, Class<T> clazz) {
        InputStreamReader streamReader = this.createReader(connection);
        if (streamReader == null) {
            return new HttpResponse(-1, null);
        }
        int responseCode = -1;
        try {
            responseCode = connection.getResponseCode();
            Object response = this.gson.fromJson((Reader)streamReader, clazz);
            HttpResponse httpResponse = new HttpResponse(responseCode, response);
            return httpResponse;
        }
        catch (Exception ignored) {
            HttpResponse httpResponse = new HttpResponse(responseCode, null);
            return httpResponse;
        }
        finally {
            try {
                streamReader.close();
            }
            catch (Exception exception) {}
        }
    }

    private <T> @NonNull HttpResponse<T> readResponseSilent(HttpURLConnection connection, Class<T> clazz) {
        try {
            return this.readResponse(connection, clazz);
        }
        catch (Exception ignored) {
            return new HttpResponse(-1, null);
        }
    }

    private @NonNull DefaultHttpResponse readDefaultResponse(HttpURLConnection connection) {
        InputStreamReader streamReader = this.createReader(connection);
        if (streamReader == null) {
            return new DefaultHttpResponse(-1, null);
        }
        try {
            int responseCode = connection.getResponseCode();
            JsonObject response = (JsonObject)this.gson.fromJson((Reader)streamReader, JsonObject.class);
            DefaultHttpResponse defaultHttpResponse = new DefaultHttpResponse(responseCode, response);
            return defaultHttpResponse;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to read response", exception);
        }
        finally {
            try {
                streamReader.close();
            }
            catch (Exception exception) {}
        }
    }

    private @Nullable InputStreamReader createReader(HttpURLConnection connection) {
        InputStream stream;
        try {
            stream = connection.getInputStream();
        }
        catch (Exception exception) {
            stream = connection.getErrorStream();
        }
        if (stream != null) {
            return new InputStreamReader(stream);
        }
        return null;
    }

    public static final class DefaultHttpResponse
    extends HttpResponse<JsonObject> {
        DefaultHttpResponse(int httpCode, JsonObject response) {
            super(httpCode, response);
        }
    }

    public static class HttpResponse<T> {
        private final int httpCode;
        private final T response;

        public boolean isCodeOk() {
            return this.httpCode >= 200 && this.httpCode < 300;
        }

        public int getHttpCode() {
            return this.httpCode;
        }

        public T getResponse() {
            return this.response;
        }

        private HttpResponse(int httpCode, T response) {
            this.httpCode = httpCode;
            this.response = response;
        }
    }
}

