/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.velocity.arguments;

import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.floodgate.shadow.cloud.commandframework.ArgumentDescription;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.CommandArgument;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ArgumentParseResult;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ArgumentParser;
import org.geysermc.floodgate.shadow.cloud.commandframework.captions.CaptionVariable;
import org.geysermc.floodgate.shadow.cloud.commandframework.context.CommandContext;
import org.geysermc.floodgate.shadow.cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import org.geysermc.floodgate.shadow.cloud.commandframework.exceptions.parsing.ParserException;
import org.geysermc.floodgate.shadow.cloud.commandframework.velocity.VelocityCaptionKeys;
import org.geysermc.floodgate.shadow.io.leangen.geantyref.TypeToken;

public final class ServerArgument<C>
extends CommandArgument<C, RegisteredServer> {
    private ServerArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription, @NonNull Collection<@NonNull BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>>> argumentPreprocessors) {
        super(required, name, new ServerParser(), defaultValue, TypeToken.get(RegisteredServer.class), suggestionsProvider, defaultDescription, argumentPreprocessors);
    }

    public static <C> @NonNull CommandArgument.Builder<C, RegisteredServer> newBuilder(@NonNull String name) {
        return new Builder(name).withParser(new ServerParser());
    }

    public static <C> @NonNull CommandArgument<C, RegisteredServer> of(@NonNull String name) {
        return ServerArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, RegisteredServer> optional(@NonNull String name) {
        return ServerArgument.newBuilder(name).asOptional().build();
    }

    public static final class ServerParser<C>
    implements ArgumentParser<C, RegisteredServer> {
        @Override
        public @NonNull ArgumentParseResult<@NonNull RegisteredServer> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(ServerParser.class, commandContext));
            }
            RegisteredServer server = ((ProxyServer)commandContext.get("ProxyServer")).getServer(input).orElse(null);
            if (server == null) {
                return ArgumentParseResult.failure(new ServerParseException(input, commandContext));
            }
            inputQueue.remove();
            return ArgumentParseResult.success(server);
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return ((ProxyServer)commandContext.get("ProxyServer")).getAllServers().stream().map((? super T s2) -> s2.getServerInfo().getName()).collect(Collectors.toList());
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, RegisteredServer> {
        private Builder(@NonNull String name) {
            super(TypeToken.get(RegisteredServer.class), name);
        }

        @Override
        public @NonNull CommandArgument<@NonNull C, @NonNull RegisteredServer> build() {
            return new ServerArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription(), new LinkedList());
        }
    }

    public static final class ServerParseException
    extends ParserException {
        private static final long serialVersionUID = 9168156226853233788L;

        private ServerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(ServerParser.class, context, VelocityCaptionKeys.ARGUMENT_PARSE_FAILURE_SERVER, CaptionVariable.of("input", input));
        }
    }
}

