/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.velocity.arguments;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.floodgate.shadow.cloud.commandframework.ArgumentDescription;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.CommandArgument;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ArgumentParseResult;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ArgumentParser;
import org.geysermc.floodgate.shadow.cloud.commandframework.captions.CaptionVariable;
import org.geysermc.floodgate.shadow.cloud.commandframework.context.CommandContext;
import org.geysermc.floodgate.shadow.cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import org.geysermc.floodgate.shadow.cloud.commandframework.exceptions.parsing.ParserException;
import org.geysermc.floodgate.shadow.cloud.commandframework.velocity.VelocityCaptionKeys;
import org.geysermc.floodgate.shadow.io.leangen.geantyref.TypeToken;

public final class PlayerArgument<C>
extends CommandArgument<C, Player> {
    private PlayerArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription, @NonNull Collection<@NonNull BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>>> argumentPreprocessors) {
        super(required, name, new PlayerParser(), defaultValue, TypeToken.get(Player.class), suggestionsProvider, defaultDescription, argumentPreprocessors);
    }

    public static <C> @NonNull CommandArgument.Builder<C, Player> newBuilder(@NonNull String name) {
        return new Builder(name).withParser(new PlayerParser());
    }

    public static <C> @NonNull CommandArgument<C, Player> of(@NonNull String name) {
        return PlayerArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Player> optional(@NonNull String name) {
        return PlayerArgument.newBuilder(name).asOptional().build();
    }

    public static final class PlayerParser<C>
    implements ArgumentParser<C, Player> {
        @Override
        public @NonNull ArgumentParseResult<@NonNull Player> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(PlayerParser.class, commandContext));
            }
            Player player = ((ProxyServer)commandContext.get("ProxyServer")).getPlayer(input).orElse(null);
            if (player == null) {
                return ArgumentParseResult.failure(new PlayerParseException(input, commandContext));
            }
            inputQueue.remove();
            return ArgumentParseResult.success(player);
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return ((ProxyServer)commandContext.get("ProxyServer")).getAllPlayers().stream().map(Player::getUsername).collect(Collectors.toList());
        }

        @Override
        public boolean isContextFree() {
            return true;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Player> {
        private Builder(@NonNull String name) {
            super(TypeToken.get(Player.class), name);
        }

        @Override
        public @NonNull CommandArgument<@NonNull C, @NonNull Player> build() {
            return new PlayerArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription(), new LinkedList());
        }
    }

    public static final class PlayerParseException
    extends ParserException {
        private static final long serialVersionUID = -4839583631837040297L;

        private PlayerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(PlayerParser.class, context, VelocityCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, CaptionVariable.of("input", input));
        }
    }
}

