/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.velocity;

import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.shadow.cloud.commandframework.Command;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.CommandArgument;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.StaticArgument;
import org.geysermc.floodgate.shadow.cloud.commandframework.brigadier.CloudBrigadierManager;
import org.geysermc.floodgate.shadow.cloud.commandframework.context.CommandContext;
import org.geysermc.floodgate.shadow.cloud.commandframework.internal.CommandRegistrationHandler;
import org.geysermc.floodgate.shadow.cloud.commandframework.permission.CommandPermission;
import org.geysermc.floodgate.shadow.cloud.commandframework.velocity.VelocityCommandManager;
import org.geysermc.floodgate.shadow.cloud.commandframework.velocity.VelocityExecutor;

final class VelocityPluginRegistrationHandler<C>
implements CommandRegistrationHandler {
    private CloudBrigadierManager<C, CommandSource> brigadierManager;
    private VelocityCommandManager<C> manager;

    VelocityPluginRegistrationHandler() {
    }

    void initialize(@NonNull VelocityCommandManager<C> velocityCommandManager) {
        this.manager = velocityCommandManager;
        this.brigadierManager = new CloudBrigadierManager(velocityCommandManager, () -> new CommandContext(velocityCommandManager.commandSenderMapper().apply((CommandSource)velocityCommandManager.proxyServer().getConsoleCommandSource()), velocityCommandManager));
        this.brigadierManager.brigadierSenderMapper(sender -> this.manager.commandSenderMapper().apply((CommandSource)sender));
        this.brigadierManager.backwardsBrigadierSenderMapper(this.manager.backwardsCommandSenderMapper());
    }

    @Override
    public boolean registerCommand(@NonNull Command<?> command) {
        CommandArgument<?, ?> argument = command.getArguments().get(0);
        List<String> aliases = ((StaticArgument)argument).getAlternativeAliases();
        BrigadierCommand brigadierCommand = new BrigadierCommand(this.brigadierManager.createLiteralCommandNode(command.getArguments().get(0).getName(), command, (c, p) -> this.manager.hasPermission(this.manager.commandSenderMapper().apply((CommandSource)c), (CommandPermission)p), true, new VelocityExecutor<C>(this.manager)));
        CommandMeta commandMeta = this.manager.proxyServer().getCommandManager().metaBuilder(brigadierCommand).aliases(aliases.toArray(new String[0])).build();
        aliases.forEach(arg_0 -> ((CommandManager)this.manager.proxyServer().getCommandManager()).unregister(arg_0));
        this.manager.proxyServer().getCommandManager().register(commandMeta, (com.velocitypowered.api.command.Command)brigadierCommand);
        return true;
    }

    @NonNull CloudBrigadierManager<C, CommandSource> brigadierManager() {
        return this.brigadierManager;
    }
}

