/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.exceptions.parsing;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.shadow.cloud.commandframework.captions.CaptionVariable;
import org.geysermc.floodgate.shadow.cloud.commandframework.captions.StandardCaptionKeys;
import org.geysermc.floodgate.shadow.cloud.commandframework.context.CommandContext;
import org.geysermc.floodgate.shadow.cloud.commandframework.exceptions.parsing.ParserException;

public abstract class NumberParseException
extends ParserException {
    private static final long serialVersionUID = 3018775374056029797L;
    private final String input;
    private final Number min;
    private final Number max;

    protected NumberParseException(@NonNull String input, @NonNull Number min2, @NonNull Number max, @NonNull Class<?> parserClass, @NonNull CommandContext<?> context) {
        super(parserClass, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_NUMBER, CaptionVariable.of("input", input), CaptionVariable.of("min", String.valueOf(min2)), CaptionVariable.of("max", String.valueOf(max)));
        this.input = input;
        this.min = min2;
        this.max = max;
    }

    public abstract @NonNull String getNumberType();

    public abstract boolean hasMax();

    public abstract boolean hasMin();

    public @NonNull String getInput() {
        return this.input;
    }

    public Number getMin() {
        return this.min;
    }

    public Number getMax() {
        return this.max;
    }
}

