/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.news;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.command.util.Permission;
import org.geysermc.floodgate.news.NewsItem;
import org.geysermc.floodgate.news.NewsItemAction;
import org.geysermc.floodgate.news.data.AnnouncementData;
import org.geysermc.floodgate.news.data.BuildSpecificData;
import org.geysermc.floodgate.news.data.CheckAfterData;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.util.AutoBind;
import org.geysermc.floodgate.util.HttpClient;

@AutoBind
public class NewsChecker {
    private final Map<Integer, NewsItem> activeNewsItems = new HashMap<Integer, NewsItem>();
    @Inject
    @Named(value="commonScheduledPool")
    private ScheduledExecutorService executorService;
    @Inject
    private CommandUtil commandUtil;
    @Inject
    private HttpClient httpClient;
    @Inject
    private FloodgateLogger logger;
    @Inject
    @Named(value="gitBranch")
    private String branch;
    @Inject
    @Named(value="buildNumber")
    private int build;
    private boolean firstCheck;

    @Inject
    public void start() {
        this.executorService.scheduleWithFixedDelay(this::checkNews, 0L, 30L, TimeUnit.MINUTES);
    }

    private void schedule(long delayMs) {
        this.executorService.schedule(this::checkNews, delayMs, TimeUnit.MILLISECONDS);
    }

    private void checkNews() {
        block4: {
            HttpClient.HttpResponse<JsonArray> response = this.httpClient.getSilent("https://api.geysermc.org/v2/news/floodgate", JsonArray.class);
            JsonArray array = response.getResponse();
            if (array == null || !response.isCodeOk()) {
                return;
            }
            try {
                for (JsonElement newsItemElement : array) {
                    NewsItem newsItem = NewsItem.readItem(newsItemElement.getAsJsonObject());
                    if (newsItem == null) continue;
                    this.addNews(newsItem);
                }
                this.firstCheck = false;
            }
            catch (Exception e) {
                if (!this.logger.isDebug()) break block4;
                this.logger.error("Error while reading news item", e, new Object[0]);
            }
        }
    }

    public void handleNews(Object player, NewsItemAction action) {
        for (NewsItem news : this.getActiveNews(action)) {
            this.handleNewsItem(player, news, action);
        }
    }

    private void handleNewsItem(Object player, NewsItem news, NewsItemAction action) {
        switch (action) {
            case ON_SERVER_STARTED: {
                if (!this.firstCheck) {
                    return;
                }
            }
            case BROADCAST_TO_CONSOLE: {
                this.logger.info(news.getMessage(), new Object[0]);
                break;
            }
            case ON_OPERATOR_JOIN: {
                if (player == null) {
                    return;
                }
                if (!this.commandUtil.hasPermission(player, Permission.NEWS_RECEIVE.get())) break;
                String message = "\u00a7a " + news.getMessage();
                this.commandUtil.sendMessage(player, message);
                break;
            }
            case BROADCAST_TO_OPERATORS: {
                Collection<Object> onlinePlayers = this.commandUtil.getOnlinePlayersWithPermission(Permission.NEWS_RECEIVE.get());
                for (Object onlinePlayer : onlinePlayers) {
                    String message = "\u00a7a " + news.getMessage();
                    this.commandUtil.sendMessage(onlinePlayer, message);
                }
                break;
            }
        }
    }

    public Collection<NewsItem> getActiveNews() {
        return this.activeNewsItems.values();
    }

    public Collection<NewsItem> getActiveNews(NewsItemAction action) {
        ArrayList<NewsItem> news = new ArrayList<NewsItem>();
        for (NewsItem item : this.getActiveNews()) {
            if (!item.getActions().contains((Object)action)) continue;
            news.add(item);
        }
        return news;
    }

    public void addNews(NewsItem item) {
        if (this.activeNewsItems.containsKey(item.getId())) {
            if (!item.isActive()) {
                this.activeNewsItems.remove(item.getId());
            }
            return;
        }
        if (!item.isActive()) {
            return;
        }
        switch (item.getType()) {
            case ANNOUNCEMENT: {
                if (item.getDataAs(AnnouncementData.class).isAffected("floodgate")) break;
                return;
            }
            case BUILD_SPECIFIC: {
                if (item.getDataAs(BuildSpecificData.class).isAffected(this.branch, this.build)) break;
                return;
            }
            case CHECK_AFTER: {
                long checkAfter = item.getDataAs(CheckAfterData.class).getCheckAfter();
                long delayMs = System.currentTimeMillis() - checkAfter;
                this.schedule(delayMs > 0L ? delayMs : 0L);
                break;
            }
        }
        this.activeNewsItems.put(item.getId(), item);
        this.activateNews(item);
    }

    private void activateNews(NewsItem item) {
        for (NewsItemAction action : item.getActions()) {
            this.handleNewsItem(null, item, action);
        }
    }
}

