/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.module;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.proxy.ProxyServer;
import org.geysermc.floodgate.VelocityPlugin;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.inject.velocity.VelocityInjector;
import org.geysermc.floodgate.listener.VelocityListenerRegistration;
import org.geysermc.floodgate.logger.Slf4jFloodgateLogger;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.platform.listener.ListenerRegistration;
import org.geysermc.floodgate.platform.pluginmessage.PluginMessageUtils;
import org.geysermc.floodgate.platform.util.PlatformUtils;
import org.geysermc.floodgate.player.FloodgateCommandPreprocessor;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.pluginmessage.PluginMessageManager;
import org.geysermc.floodgate.pluginmessage.PluginMessageRegistration;
import org.geysermc.floodgate.pluginmessage.VelocityPluginMessageRegistration;
import org.geysermc.floodgate.pluginmessage.VelocityPluginMessageUtils;
import org.geysermc.floodgate.shadow.cloud.commandframework.CommandManager;
import org.geysermc.floodgate.shadow.cloud.commandframework.execution.CommandExecutionCoordinator;
import org.geysermc.floodgate.shadow.cloud.commandframework.velocity.CloudInjectionModule;
import org.geysermc.floodgate.shadow.cloud.commandframework.velocity.VelocityCommandManager;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.util.VelocityCommandUtil;
import org.geysermc.floodgate.util.VelocityPlatformUtils;
import org.geysermc.floodgate.util.VelocitySkinApplier;

public final class VelocityPlatformModule
extends AbstractModule {
    private final Injector guice;

    protected void configure() {
        this.bind(CommandUtil.class).to(VelocityCommandUtil.class);
        this.bind(PlatformUtils.class).to(VelocityPlatformUtils.class);
        this.bind(FloodgateLogger.class).to(Slf4jFloodgateLogger.class);
        this.bind(SkinApplier.class).to(VelocitySkinApplier.class);
    }

    @Provides
    @Singleton
    public CommandManager<UserAudience> commandManager(CommandUtil commandUtil) {
        Module[] moduleArray = new Module[1];
        moduleArray[0] = new CloudInjectionModule<UserAudience>(UserAudience.class, CommandExecutionCoordinator.simpleCoordinator(), commandUtil::getUserAudience, audience -> (CommandSource)audience.source());
        Injector child = this.guice.createChildInjector(moduleArray);
        CommandManager commandManager = (CommandManager)child.getInstance((Key)new Key<VelocityCommandManager<UserAudience>>(){});
        commandManager.registerCommandPreProcessor(new FloodgateCommandPreprocessor(commandUtil));
        return commandManager;
    }

    @Provides
    @Singleton
    public ListenerRegistration<Object> listenerRegistration(EventManager eventManager, VelocityPlugin plugin) {
        return new VelocityListenerRegistration(eventManager, plugin);
    }

    @Provides
    @Singleton
    public PluginMessageUtils pluginMessageUtils(PluginMessageManager pluginMessageManager) {
        return new VelocityPluginMessageUtils(pluginMessageManager);
    }

    @Provides
    @Singleton
    public PluginMessageRegistration pluginMessageRegistration(ProxyServer proxy) {
        return new VelocityPluginMessageRegistration(proxy);
    }

    @Provides
    @Singleton
    public CommonPlatformInjector platformInjector(ProxyServer server) {
        return new VelocityInjector(server);
    }

    @Provides
    @Named(value="packetEncoder")
    public String packetEncoder() {
        return "minecraft-encoder";
    }

    @Provides
    @Named(value="packetDecoder")
    public String packetDecoder() {
        return "minecraft-decoder";
    }

    @Provides
    @Named(value="packetHandler")
    public String packetHandler() {
        return "handler";
    }

    @Provides
    @Named(value="implementationName")
    public String implementationName() {
        return "Velocity";
    }

    public VelocityPlatformModule(Injector guice) {
        this.guice = guice;
    }
}

