/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import org.geysermc.floodgate.addon.data.CommonDataHandler;
import org.geysermc.floodgate.addon.data.PacketBlocker;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class VelocityProxyDataHandler
extends CommonDataHandler {
    private static final Field HANDSHAKE;
    private static final Class<?> HANDSHAKE_PACKET;
    private static final Field HANDSHAKE_SERVER_ADDRESS;
    private static final Field REMOTE_ADDRESS;
    private static final Class<?> SERVER_LOGIN_PACKET;
    private static final Method GET_SESSION_HANDLER;
    private static final Class<?> INITIAL_LOGIN_SESSION_HANDLER;
    private static final Field FORCE_KEY_AUTHENTICATION;
    private final FloodgateLogger logger;

    public VelocityProxyDataHandler(FloodgateConfig config, FloodgateHandshakeHandler handshakeHandler, PacketBlocker blocker, AttributeKey<String> kickMessageAttribute, FloodgateLogger logger) {
        super(handshakeHandler, config, kickMessageAttribute, blocker);
        this.logger = logger;
    }

    @Override
    protected void setNewIp(Channel channel, InetSocketAddress newIp) {
        ReflectionUtils.setValue((Object)channel.pipeline().get("handler"), REMOTE_ADDRESS, (Object)newIp);
    }

    @Override
    protected Object setHostname(Object handshakePacket, String hostname) {
        ReflectionUtils.setValue(handshakePacket, HANDSHAKE_SERVER_ADDRESS, (Object)hostname);
        return handshakePacket;
    }

    @Override
    protected boolean shouldRemoveHandler(FloodgateHandshakeHandler.HandshakeResult result) {
        if (result.getResultType() == FloodgateHandshakeHandler.ResultType.SUCCESS) {
            FloodgatePlayer player = result.getFloodgatePlayer();
            this.logger.info("Floodgate player who is logged in as {} {} joined", player.getCorrectUsername(), player.getCorrectUniqueId());
            boolean forceKeyAuthentication = Boolean.getBoolean("auth.forceSecureProfiles");
            return !forceKeyAuthentication;
        }
        return super.shouldRemoveHandler(result);
    }

    @Override
    public boolean channelRead(Object packet) {
        if (HANDSHAKE_PACKET.isInstance(packet)) {
            this.handle(packet, (String)ReflectionUtils.getCastedValue(packet, HANDSHAKE_SERVER_ADDRESS));
            return false;
        }
        if (SERVER_LOGIN_PACKET.isInstance(packet)) {
            ChannelHandler minecraftConnection = this.ctx.pipeline().get("handler");
            Object sessionHandler = ReflectionUtils.invoke(minecraftConnection, GET_SESSION_HANDLER, new Object[0]);
            if (!INITIAL_LOGIN_SESSION_HANDLER.isInstance(sessionHandler)) {
                this.logger.error("Expected player's session handler to be InitialLoginSessionHandler", new Object[0]);
                return true;
            }
            if (FORCE_KEY_AUTHENTICATION != null) {
                ReflectionUtils.setValue(sessionHandler, FORCE_KEY_AUTHENTICATION, (Object)false);
            }
        }
        return true;
    }

    static {
        Class<?> iic = ReflectionUtils.getPrefixedClass("connection.client.InitialInboundConnection");
        Preconditions.checkNotNull(iic, (Object)"InitialInboundConnection class cannot be null");
        HANDSHAKE = ReflectionUtils.getField(iic, "handshake");
        Preconditions.checkNotNull((Object)HANDSHAKE, (Object)"Handshake field cannot be null");
        HANDSHAKE_PACKET = ReflectionUtils.getPrefixedClass("protocol.packet.Handshake");
        Preconditions.checkNotNull(HANDSHAKE_PACKET, (Object)"Handshake packet class cannot be null");
        HANDSHAKE_SERVER_ADDRESS = ReflectionUtils.getField(HANDSHAKE_PACKET, "serverAddress");
        Preconditions.checkNotNull((Object)HANDSHAKE_SERVER_ADDRESS, (Object)"Address in the Handshake packet cannot be null");
        Class<?> minecraftConnection = ReflectionUtils.getPrefixedClass("connection.MinecraftConnection");
        REMOTE_ADDRESS = ReflectionUtils.getField(minecraftConnection, "remoteAddress");
        Preconditions.checkNotNull((Object)REMOTE_ADDRESS, (Object)"remoteAddress cannot be null");
        SERVER_LOGIN_PACKET = ReflectionUtils.getPrefixedClass("protocol.packet.ServerLogin");
        Preconditions.checkNotNull(SERVER_LOGIN_PACKET, (Object)"ServerLogin packet class cannot be null");
        Method sessionHandler = ReflectionUtils.getMethodByName(minecraftConnection, "getSessionHandler", true);
        if (sessionHandler == null) {
            sessionHandler = ReflectionUtils.getMethodByName(minecraftConnection, "getActiveSessionHandler", true);
        }
        GET_SESSION_HANDLER = sessionHandler;
        Preconditions.checkNotNull((Object)GET_SESSION_HANDLER, (Object)"getSessionHandler method cannot be null");
        INITIAL_LOGIN_SESSION_HANDLER = ReflectionUtils.getPrefixedClass("connection.client.InitialLoginSessionHandler");
        Preconditions.checkNotNull(INITIAL_LOGIN_SESSION_HANDLER, (Object)"InitialLoginSessionHandler cannot be null");
        FORCE_KEY_AUTHENTICATION = ReflectionUtils.getField(INITIAL_LOGIN_SESSION_HANDLER, "forceKeyAuthentication");
    }
}

