/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.velocitypowered.api.proxy.ProxyServer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.AttributeKey;
import org.geysermc.floodgate.addon.data.PacketBlocker;
import org.geysermc.floodgate.addon.data.VelocityProxyDataHandler;
import org.geysermc.floodgate.addon.data.VelocityServerDataHandler;
import org.geysermc.floodgate.api.ProxyFloodgateApi;
import org.geysermc.floodgate.api.inject.InjectorAddon;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;

public final class VelocityDataAddon
implements InjectorAddon {
    @Inject
    private FloodgateHandshakeHandler handshakeHandler;
    @Inject
    private ProxyFloodgateConfig config;
    @Inject
    private ProxyFloodgateApi api;
    @Inject
    private ProxyServer proxy;
    @Inject
    private FloodgateLogger logger;
    @Inject
    @Named(value="packetHandler")
    private String packetHandler;
    @Inject
    @Named(value="packetDecoder")
    private String packetDecoder;
    @Inject
    @Named(value="packetEncoder")
    private String packetEncoder;
    @Inject
    @Named(value="kickMessageAttribute")
    private AttributeKey<String> kickMessageAttribute;
    @Inject
    @Named(value="playerAttribute")
    private AttributeKey<FloodgatePlayer> playerAttribute;

    @Override
    public void onInject(Channel channel, boolean toServer) {
        if (toServer) {
            if (this.config.isSendFloodgateData()) {
                channel.pipeline().addAfter(this.packetEncoder, "floodgate_data_handler", (ChannelHandler)new VelocityServerDataHandler(this.api, this.proxy));
            }
            return;
        }
        PacketBlocker blocker = new PacketBlocker();
        channel.pipeline().addBefore(this.packetDecoder, "floodgate_packet_blocker", (ChannelHandler)blocker);
        channel.pipeline().addBefore(this.packetHandler, "floodgate_data_handler", (ChannelHandler)new VelocityProxyDataHandler(this.config, this.handshakeHandler, blocker, this.kickMessageAttribute, this.logger));
    }

    @Override
    public void onChannelClosed(Channel channel) {
        FloodgatePlayer player = (FloodgatePlayer)channel.attr(this.playerAttribute).get();
        if (player != null && this.api.setPendingRemove(player)) {
            this.logger.translatedInfo("floodgate.ingame.disconnect_name", player.getUsername());
        }
    }

    @Override
    public void onRemoveInject(Channel channel) {
    }

    @Override
    public boolean shouldInject() {
        return true;
    }
}

