/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.UUID;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.InstanceHolder;
import org.geysermc.floodgate.api.event.FloodgateEventBus;
import org.geysermc.floodgate.api.handshake.HandshakeHandlers;
import org.geysermc.floodgate.api.inject.PlatformInjector;
import org.geysermc.floodgate.api.link.PlayerLink;
import org.geysermc.floodgate.api.packet.PacketHandlers;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.event.EventBus;
import org.geysermc.floodgate.event.lifecycle.PostEnableEvent;
import org.geysermc.floodgate.event.lifecycle.ShutdownEvent;
import org.geysermc.floodgate.module.PostInitializeModule;

public class FloodgatePlatform {
    private static final UUID KEY = UUID.randomUUID();
    @Inject
    private PlatformInjector injector;
    @Inject
    private FloodgateConfig config;
    @Inject
    private Injector guice;

    @Inject
    public void init(FloodgateApi api, PlayerLink link, FloodgateEventBus eventBus, PacketHandlers packetHandlers, HandshakeHandlers handshakeHandlers) {
        InstanceHolder.set(api, link, eventBus, this.injector, packetHandlers, handshakeHandlers, KEY);
    }

    public void enable(Module ... postInitializeModules) throws RuntimeException {
        if (this.injector == null) {
            throw new RuntimeException("Failed to find the platform injector!");
        }
        try {
            this.injector.inject();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to inject the packet listener!", exception);
        }
        this.guice = this.guice.createChildInjector(new Module[]{new PostInitializeModule(postInitializeModules)});
        ((EventBus)this.guice.getInstance(EventBus.class)).fire(new PostEnableEvent());
    }

    public void disable() {
        ((EventBus)this.guice.getInstance(EventBus.class)).fire(new ShutdownEvent());
        if (this.injector != null && this.injector.canRemoveInjection()) {
            try {
                this.injector.removeInjection();
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to remove the injection!", exception);
            }
        }
    }

    public boolean isProxy() {
        return this.config.isProxy();
    }
}

