/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.event.bus.impl.util;

import java.util.HashSet;
import java.util.Set;
import org.geysermc.event.Cancellable;
import org.geysermc.event.NotSubscribable;
import org.geysermc.event.subscribe.Subscriber;

public final class Utils {
    public static boolean isEventCancelled(Object event) {
        return event instanceof Cancellable && ((Cancellable)event).isCancelled();
    }

    public static boolean shouldCallSubscriber(Subscriber<?> subscriber, Object event) {
        return subscriber.ignoreCancelled() || !Utils.isEventCancelled(event);
    }

    public static Set<Class<?>> ancestorsThatUse(Class<?> clazz, Class<?> use) {
        HashSet types = new HashSet();
        Utils.ancestorsThatUse(types, clazz, use);
        return types;
    }

    private static boolean ancestorsThatUse(Set<Class<?>> types, Class<?> type, Class<?> use) {
        if (type == use) {
            return true;
        }
        boolean shouldAdd = false;
        for (Class<?> clazz : type.getInterfaces()) {
            shouldAdd |= Utils.ancestorsThatUse(types, clazz, use);
        }
        Class<?> superClass = type.getSuperclass();
        if (superClass != null) {
            shouldAdd |= Utils.ancestorsThatUse(types, superClass, use);
        }
        if (Object.class == use) {
            shouldAdd = true;
        }
        if (shouldAdd && type.getAnnotation(NotSubscribable.class) == null) {
            types.add(type);
        }
        return shouldAdd;
    }
}

