/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.parser.template.action.predefined;

import java.util.ArrayList;
import java.util.List;
import org.geysermc.configutils.file.template.TemplateReader;
import org.geysermc.configutils.parser.placeholder.Placeholders;
import org.geysermc.configutils.parser.template.action.ActionResult;
import org.geysermc.configutils.parser.template.action.SingleAction;
import org.geysermc.configutils.parser.template.action.predefined.DefineImportAction;
import org.geysermc.configutils.parser.template.action.storage.Singleton;
import org.geysermc.configutils.parser.template.action.storage.Storable;
import org.geysermc.configutils.parser.template.action.storage.Storables;
import org.geysermc.configutils.parser.template.action.storage.Unfinished;

public class ImportSectionAction
implements SingleAction,
Storable,
Singleton,
Unfinished {
    private int line;

    @Override
    public String friendlyName() {
        return "import section";
    }

    @Override
    public char actionPrefix() {
        return '|';
    }

    @Override
    public ActionResult handle(String strippedLine, Storables storables, Placeholders placeholders, TemplateReader reader) {
        int line;
        if (strippedLine.length() <= 1) {
            ImportSectionAction importSection = storables.removeFirst(ImportSectionAction.class);
            if (importSection == null) {
                return ActionResult.failed("Cannot close an section that wasn't opened");
            }
            storables.add(new LastImportSection(importSection.line()));
            return ActionResult.ok();
        }
        Unfinished unfinished = storables.firstUnfinished(ImportSectionAction.class);
        if (unfinished != null) {
            return ActionResult.failed(unfinished.unfinishedMessage(this));
        }
        DefineImportAction defineImport = storables.first(DefineImportAction.class);
        if (defineImport == null) {
            return ActionResult.failed("Cannot start insert without providing a config to import from");
        }
        try {
            line = Integer.parseInt(strippedLine.substring(1)) - 1;
        }
        catch (NumberFormatException e) {
            return ActionResult.failed(String.format("'%s' is not a valid number", strippedLine));
        }
        if (line < 0) {
            return ActionResult.failed("Cannot read a negative line number");
        }
        this.line = line;
        storables.add(this);
        int startLine = 0;
        LastImportSection lastImport = storables.removeFirst(LastImportSection.class);
        if (lastImport != null) {
            startLine = lastImport.lastLine();
        }
        List<String> lines = defineImport.lines();
        ArrayList<String> linesToAdd = new ArrayList<String>();
        for (int i = startLine; i < line; ++i) {
            linesToAdd.add(placeholders.replacePlaceholders(lines.get(i)));
        }
        return ActionResult.addLines(linesToAdd);
    }

    public int line() {
        return this.line;
    }

    @Override
    public SingleAction newInstance() {
        return new ImportSectionAction();
    }

    static class LastImportSection
    implements Storable,
    Singleton {
        private final int lastLine;

        public LastImportSection(int lastLine) {
            this.lastLine = lastLine;
        }

        public int lastLine() {
            return this.lastLine;
        }
    }
}

