/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.parser.template;

import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.configutils.parser.template.action.storage.Storables;

public final class TemplateParseResult {
    private final List<String> lines;
    private final Storables storables;
    private final Throwable error;

    private TemplateParseResult(List<String> lines, Storables storables, Throwable error) {
        this.lines = lines;
        this.storables = storables;
        this.error = error;
    }

    public static @NonNull TemplateParseResult ok(@NonNull List<String> lines, @NonNull Storables storables) {
        return new TemplateParseResult(Objects.requireNonNull(lines), Objects.requireNonNull(storables), null);
    }

    public static @NonNull TemplateParseResult failed(@NonNull Throwable error) {
        return new TemplateParseResult(null, null, error);
    }

    public @Nullable Throwable error() {
        return this.error;
    }

    public @Nullable List<String> templateLines() {
        return this.lines;
    }

    public @Nullable Storables storables() {
        return this.storables;
    }

    public boolean succeeded() {
        return this.error == null;
    }
}

