/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import com.google.inject.Inject;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.Utils;

public final class VelocityCommandUtil
extends CommandUtil {
    private static UserAudience console;
    @Inject
    private ProxyServer server;

    @Inject
    public VelocityCommandUtil(LanguageManager manager, FloodgateApi api) {
        super(manager, api);
    }

    @Override
    public @NonNull UserAudience getUserAudience(@NonNull Object sourceObj) {
        if (!(sourceObj instanceof CommandSource)) {
            throw new IllegalArgumentException("Can only work with CommandSource!");
        }
        CommandSource source = (CommandSource)sourceObj;
        if (!(source instanceof Player)) {
            if (console != null) {
                return console;
            }
            console = new UserAudience.ConsoleAudience(source, this);
            return console;
        }
        Player player = (Player)source;
        UUID uuid = player.getUniqueId();
        String username = player.getUsername();
        String locale = Utils.getLocale(player.getPlayerSettings().getLocale());
        return new UserAudience.PlayerAudience(uuid, username, locale, source, this, true);
    }

    @Override
    protected String getUsernameFromSource(@NonNull Object source) {
        return ((Player)source).getUsername();
    }

    @Override
    protected UUID getUuidFromSource(@NonNull Object source) {
        return ((Player)source).getUniqueId();
    }

    @Override
    protected Collection<?> getOnlinePlayers() {
        return this.server.getAllPlayers();
    }

    @Override
    public Object getPlayerByUuid(@NonNull UUID uuid) {
        Optional player = this.server.getPlayer(uuid);
        return player.isPresent() ? player.get() : uuid;
    }

    @Override
    public Object getPlayerByUsername(@NonNull String username) {
        Optional player = this.server.getPlayer(username);
        return player.isPresent() ? player.get() : username;
    }

    @Override
    public boolean hasPermission(Object player, String permission) {
        return ((CommandSource)player).hasPermission(permission);
    }

    @Override
    public void sendMessage(Object target, String message) {
        ((CommandSource)target).sendMessage((Component)Component.text((String)message));
    }

    @Override
    public void kickPlayer(Object player, String message) {
        if (player instanceof Player) {
            ((Player)player).disconnect((Component)Component.text((String)message));
        }
    }
}

