/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.velocity;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.floodgate.shadow.cloud.commandframework.CommandManager;
import org.geysermc.floodgate.shadow.cloud.commandframework.CommandTree;
import org.geysermc.floodgate.shadow.cloud.commandframework.brigadier.BrigadierManagerHolder;
import org.geysermc.floodgate.shadow.cloud.commandframework.brigadier.CloudBrigadierManager;
import org.geysermc.floodgate.shadow.cloud.commandframework.captions.FactoryDelegatingCaptionRegistry;
import org.geysermc.floodgate.shadow.cloud.commandframework.execution.CommandExecutionCoordinator;
import org.geysermc.floodgate.shadow.cloud.commandframework.meta.CommandMeta;
import org.geysermc.floodgate.shadow.cloud.commandframework.meta.SimpleCommandMeta;
import org.geysermc.floodgate.shadow.cloud.commandframework.velocity.VelocityCaptionKeys;
import org.geysermc.floodgate.shadow.cloud.commandframework.velocity.VelocityCommandPreprocessor;
import org.geysermc.floodgate.shadow.cloud.commandframework.velocity.VelocityPluginRegistrationHandler;
import org.geysermc.floodgate.shadow.cloud.commandframework.velocity.arguments.PlayerArgument;
import org.geysermc.floodgate.shadow.cloud.commandframework.velocity.arguments.ServerArgument;
import org.geysermc.floodgate.shadow.io.leangen.geantyref.TypeToken;

@Singleton
public class VelocityCommandManager<C>
extends CommandManager<C>
implements BrigadierManagerHolder<C> {
    public static final String ARGUMENT_PARSE_FAILURE_PLAYER = "'{input}' is not a valid player";
    public static final String ARGUMENT_PARSE_FAILURE_SERVER = "'{input}' is not a valid server";
    private final ProxyServer proxyServer;
    private final Function<CommandSource, C> commandSenderMapper;
    private final Function<C, CommandSource> backwardsCommandSenderMapper;

    @Deprecated
    public VelocityCommandManager(@NonNull ProxyServer proxyServer, @NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> commandExecutionCoordinator, @NonNull Function<@NonNull CommandSource, @NonNull C> commandSenderMapper, @NonNull Function<@NonNull C, @NonNull CommandSource> backwardsCommandSenderMapper) {
        this(null, proxyServer, commandExecutionCoordinator, commandSenderMapper, backwardsCommandSenderMapper);
    }

    @Inject
    public VelocityCommandManager(@Nullable PluginContainer plugin, @NonNull ProxyServer proxyServer, @NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> commandExecutionCoordinator, @NonNull Function<@NonNull CommandSource, @NonNull C> commandSenderMapper, @NonNull Function<@NonNull C, @NonNull CommandSource> backwardsCommandSenderMapper) {
        super(commandExecutionCoordinator, new VelocityPluginRegistrationHandler());
        ((VelocityPluginRegistrationHandler)this.getCommandRegistrationHandler()).initialize(this);
        this.proxyServer = proxyServer;
        this.commandSenderMapper = commandSenderMapper;
        this.backwardsCommandSenderMapper = backwardsCommandSenderMapper;
        this.registerCommandPreProcessor(new VelocityCommandPreprocessor(this));
        this.getParserRegistry().registerParserSupplier(TypeToken.get(Player.class), parserParameters -> new PlayerArgument.PlayerParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(RegisteredServer.class), parserParameters -> new ServerArgument.ServerParser());
        if (this.getCaptionRegistry() instanceof FactoryDelegatingCaptionRegistry) {
            FactoryDelegatingCaptionRegistry factoryDelegatingCaptionRegistry = (FactoryDelegatingCaptionRegistry)this.getCaptionRegistry();
            factoryDelegatingCaptionRegistry.registerMessageFactory(VelocityCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, (context, key) -> ARGUMENT_PARSE_FAILURE_PLAYER);
            factoryDelegatingCaptionRegistry.registerMessageFactory(VelocityCaptionKeys.ARGUMENT_PARSE_FAILURE_SERVER, (context, key) -> ARGUMENT_PARSE_FAILURE_SERVER);
        }
        this.proxyServer.getEventManager().register((Object)plugin, ServerPreConnectEvent.class, ev -> this.lockRegistration());
    }

    @Override
    public final boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        return this.backwardsCommandSenderMapper.apply(sender).hasPermission(permission);
    }

    @Override
    public final @NonNull CommandMeta createDefaultCommandMeta() {
        return SimpleCommandMeta.empty();
    }

    @Override
    public @NonNull CloudBrigadierManager<C, CommandSource> brigadierManager() {
        return ((VelocityPluginRegistrationHandler)this.getCommandRegistrationHandler()).brigadierManager();
    }

    final @NonNull ProxyServer proxyServer() {
        return this.proxyServer;
    }

    final @NonNull Function<@NonNull CommandSource, @NonNull C> commandSenderMapper() {
        return this.commandSenderMapper;
    }

    final @NonNull Function<@NonNull C, @NonNull CommandSource> backwardsCommandSenderMapper() {
        return this.backwardsCommandSenderMapper;
    }
}

