/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.arguments.flags;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.flags.CommandFlag;

public final class FlagContext {
    public static final Object FLAG_PRESENCE_VALUE = new Object();
    private final Map<String, Object> flagValues = new HashMap<String, Object>();

    private FlagContext() {
    }

    public static @NonNull FlagContext create() {
        return new FlagContext();
    }

    public void addPresenceFlag(@NonNull CommandFlag<?> flag) {
        this.flagValues.put(flag.getName(), FLAG_PRESENCE_VALUE);
    }

    public <T> void addValueFlag(@NonNull CommandFlag<T> flag, @NonNull T value) {
        this.flagValues.put(flag.getName(), value);
    }

    public boolean isPresent(@NonNull String flag) {
        Object value = this.flagValues.get(flag);
        return FLAG_PRESENCE_VALUE.equals(value);
    }

    public boolean isPresent(@NonNull CommandFlag<Void> flag) {
        return this.isPresent(flag.getName());
    }

    public <T> @NonNull Optional<T> getValue(@NonNull String name) {
        Object value = this.flagValues.get(name);
        if (value == null) {
            return Optional.empty();
        }
        Object casted = value;
        return Optional.of(casted);
    }

    public <T> @NonNull Optional<T> getValue(@NonNull CommandFlag<T> flag) {
        return this.getValue(flag.getName());
    }

    public <T> @Nullable T getValue(@NonNull String name, @Nullable T defaultValue) {
        return this.getValue(name).orElse(defaultValue);
    }

    public <T> @Nullable T getValue(@NonNull CommandFlag<T> name, @Nullable T defaultValue) {
        return this.getValue(name).orElse(defaultValue);
    }

    public boolean hasFlag(@NonNull String name) {
        return this.getValue(name).isPresent();
    }

    public boolean hasFlag(@NonNull CommandFlag<?> flag) {
        return this.getValue(flag).isPresent();
    }

    public boolean contains(@NonNull String name) {
        return this.hasFlag(name);
    }

    public boolean contains(@NonNull CommandFlag<?> flag) {
        return this.hasFlag(flag);
    }

    public <T> @Nullable T get(@NonNull String name) {
        return this.getValue(name).orElse(null);
    }

    public <T> @Nullable T get(@NonNull CommandFlag<T> flag) {
        return this.getValue(flag).orElse(null);
    }
}

