/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.pluginmessage;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.ChannelMessageSource;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.platform.pluginmessage.PluginMessageUtils;
import org.geysermc.floodgate.pluginmessage.PluginMessageChannel;
import org.geysermc.floodgate.pluginmessage.PluginMessageManager;

public class VelocityPluginMessageUtils
extends PluginMessageUtils {
    private final PluginMessageManager pluginMessageManager;
    private ProxyServer proxy;
    private FloodgateLogger logger;

    @Inject
    public void init(ProxyServer proxy, FloodgateLogger logger) {
        this.proxy = proxy;
        this.logger = logger;
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent event) {
        String channelId = event.getIdentifier().getId();
        PluginMessageChannel channel = this.pluginMessageManager.getChannel(channelId);
        if (channel == null) {
            return;
        }
        UUID sourceUuid = null;
        String sourceUsername = null;
        PluginMessageChannel.Identity sourceIdentity = PluginMessageChannel.Identity.UNKNOWN;
        ChannelMessageSource source = event.getSource();
        if (source instanceof Player) {
            Player player = (Player)source;
            sourceUuid = player.getUniqueId();
            sourceUsername = player.getUsername();
            sourceIdentity = PluginMessageChannel.Identity.PLAYER;
        } else if (source instanceof ServerConnection) {
            sourceIdentity = PluginMessageChannel.Identity.SERVER;
        }
        PluginMessageChannel.Result result = channel.handleProxyCall(event.getData(), sourceUuid, sourceUsername, sourceIdentity);
        event.setResult(result.isAllowed() ? PluginMessageEvent.ForwardResult.forward() : PluginMessageEvent.ForwardResult.handled());
        if (!result.isAllowed() && result.getReason() != null) {
            this.logKick(source, result.getReason());
        }
    }

    private void logKick(ChannelMessageSource source, String reason) {
        this.logger.error(reason + " Closing connection", new Object[0]);
        ((Player)source).disconnect((Component)Component.text((String)reason));
    }

    public boolean sendMessage(UUID player, boolean toServer, ChannelIdentifier identifier, byte[] data) {
        if (toServer) {
            return this.proxy.getPlayer(player).flatMap(Player::getCurrentServer).map(server -> server.sendPluginMessage(identifier, data)).orElse(false);
        }
        return this.proxy.getPlayer(player).map(value -> value.sendPluginMessage(identifier, data)).orElse(false);
    }

    @Override
    public boolean sendMessage(UUID player, boolean toServer, String channel, byte[] data) {
        return this.sendMessage(player, toServer, (ChannelIdentifier)MinecraftChannelIdentifier.from((String)channel), data);
    }

    public VelocityPluginMessageUtils(PluginMessageManager pluginMessageManager) {
        this.pluginMessageManager = pluginMessageManager;
    }
}

